/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.symboltable;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.symboltable.Scope;
import com.sonar.sslr.api.symboltable.Symbol;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalScope
implements Scope {
    private final Scope enclosingScope;
    private final List<Symbol> members = Lists.newArrayList();
    private final List<Scope> nestedScopes = Lists.newArrayList();

    public LocalScope(Scope enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    @Override
    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    @Override
    public Collection<Scope> getNestedScopes() {
        return this.nestedScopes;
    }

    @Override
    public void addNestedScope(Scope nestedScope) {
        this.nestedScopes.add(nestedScope);
    }

    @Override
    public void define(Symbol symbol) {
        this.members.add(symbol);
    }

    @Override
    public Collection<Symbol> getMembers() {
        return this.members;
    }

    @Override
    public Symbol resolve(String name, Predicate predicate) {
        for (Symbol symbol : this.getMembers()) {
            if (!name.equals(symbol.getName()) || !predicate.apply(symbol)) continue;
            return symbol;
        }
        Scope enclosingScope = this.getEnclosingScope();
        return enclosingScope == null ? null : enclosingScope.resolve(name, predicate);
    }

    public String toString() {
        return "Local";
    }
}

