/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.analysis;

import com.sonar.sslr.impl.analysis.ViolationConfidence;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.util.HashMap;
import java.util.Map;

public final class Violation {
    private final Matcher affectedMatcher;
    private final RuleMatcher parentRule;
    private final ViolationConfidence confidence;
    private final Matcher[] relatedMatchers;
    private final Map<String, Object> propertyBag = new HashMap<String, Object>();

    public Violation(Matcher affectedMatcher) {
        this(affectedMatcher, null);
    }

    public Violation(Matcher affectedMatcher, RuleMatcher parentRule) {
        this(affectedMatcher, parentRule, ViolationConfidence.LOW, new Matcher[0]);
    }

    public Violation(Matcher affectedMatcher, RuleMatcher parentRule, ViolationConfidence confidence) {
        this(affectedMatcher, parentRule, confidence, new Matcher[0]);
    }

    public Violation(Matcher affectedMatcher, RuleMatcher parentRule, ViolationConfidence confidence, Matcher ... relatedMatchers) {
        this.affectedMatcher = affectedMatcher;
        this.parentRule = parentRule;
        this.confidence = confidence;
        this.relatedMatchers = relatedMatchers;
    }

    public Violation addOrReplaceProperty(String propertyName, Object value) {
        this.propertyBag.put(propertyName, value);
        return this;
    }

    public Object getProperty(String propertyName) {
        return this.propertyBag.get(propertyName);
    }

    public Matcher getAffectedMatcher() {
        return this.affectedMatcher;
    }

    public RuleMatcher getParentRule() {
        return this.parentRule;
    }

    public ViolationConfidence getConfidence() {
        return this.confidence;
    }

    public Matcher[] getRelatedMatchers() {
        return this.relatedMatchers;
    }

    public Matcher getRelatedMatcher(int n) {
        try {
            return this.relatedMatchers[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
}

