/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.LexerException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentRegexpChannel
extends Channel<Lexer> {
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Matcher matcher;
    private final String regexp;

    public CommentRegexpChannel(String regexp) {
        this.matcher = Pattern.compile(regexp).matcher("");
        this.regexp = regexp;
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        try {
            if (code.popTo(this.matcher, (Appendable)this.tmpBuilder) > 0) {
                String value = this.tmpBuilder.toString();
                Token token = Token.builder().setType(GenericTokenType.COMMENT).setValueAndOriginalValue(value).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build();
                lexer.addTrivia(Trivia.createComment(token));
                this.tmpBuilder.delete(0, this.tmpBuilder.length());
                return true;
            }
            return false;
        }
        catch (StackOverflowError e) {
            throw new LexerException("The regular expression " + this.regexp + " has led to a stack overflow error. " + "This error is certainly due to an inefficient use of alternations. See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5050507", e);
        }
    }
}

