/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierAndKeywordChannel
extends Channel<Lexer> {
    private final Map<String, TokenType> keywordsMap;
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Matcher matcher;
    private final boolean caseSensitive;

    public IdentifierAndKeywordChannel(String regexp, boolean caseSensitive, TokenType[] ... keywordSets) {
        ImmutableMap.Builder<String, TokenType> keywordsMapBuilder = ImmutableMap.builder();
        TokenType[][] arr$ = keywordSets;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TokenType[] keywords;
            for (TokenType keyword : keywords = arr$[i$]) {
                String keywordValue = caseSensitive ? keyword.getValue() : keyword.getValue().toUpperCase();
                keywordsMapBuilder.put(keywordValue, keyword);
            }
        }
        this.keywordsMap = keywordsMapBuilder.build();
        this.caseSensitive = caseSensitive;
        this.matcher = Pattern.compile(regexp).matcher("");
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        if (code.popTo(this.matcher, (Appendable)this.tmpBuilder) > 0) {
            String word;
            String wordOriginal = word = this.tmpBuilder.toString();
            if (!this.caseSensitive) {
                word = word.toUpperCase();
            }
            TokenType keywordType = this.keywordsMap.get(word);
            Token token = Token.builder().setType(keywordType == null ? GenericTokenType.IDENTIFIER : keywordType).setValueAndOriginalValue(word, wordOriginal).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build();
            lexer.addToken(token);
            this.tmpBuilder.delete(0, this.tmpBuilder.length());
            return true;
        }
        return false;
    }
}

