/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.lexer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import java.util.List;
import java.util.Set;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.javascript.api.EcmaScriptTokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcmaScriptRegexpChannel
extends Channel<Lexer> {
    private final Channel<Lexer> delegate = RegexpChannelBuilder.regexp(EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL, "/([^/\\n\\\\]*+(\\\\.)?+)*+/\\p{javaJavaIdentifierPart}*+");
    private static final Set<String> WHOLE_TOKENS = ImmutableSet.of("break", "case", "continue", "delete", "do", "else", "finally", "in", "instanceof", "return", "throw", "try", "typeof", "void", "+", "-", ".", "/", ",", "*");
    private static final String[] ENDS = new String[]{"!", "%", "&", "(", ":", ";", "<", "=", ">", "?", "[", "^", "{", "|", "}", "~"};

    @Override
    public boolean consume(CodeReader code, Lexer output) {
        Token lastToken;
        if (code.peek() == 47 && ((lastToken = EcmaScriptRegexpChannel.getLastToken(output)) == null || EcmaScriptRegexpChannel.guessNextIsRegexp(lastToken.getValue()))) {
            return this.delegate.consume(code, output);
        }
        return false;
    }

    private static Token getLastToken(Lexer output) {
        List<Token> tokens = output.getTokens();
        return tokens.isEmpty() ? null : tokens.get(tokens.size() - 1);
    }

    @VisibleForTesting
    static boolean guessNextIsRegexp(String preceder) {
        if (WHOLE_TOKENS.contains(preceder)) {
            return true;
        }
        for (String end : ENDS) {
            if (!preceder.endsWith(end)) continue;
            return true;
        }
        return false;
    }
}

