/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.definition.table;

import org.atp.spi.TypeableImpl;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.ColumnNameList;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.definition.table.ForeignKeyConstraint;
import org.sql.generation.api.grammar.definition.table.MatchType;
import org.sql.generation.api.grammar.definition.table.ReferentialAction;
import org.sql.generation.api.grammar.definition.table.TableConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyConstraintImpl
extends TypeableImpl<TableConstraint, ForeignKeyConstraint>
implements ForeignKeyConstraint {
    private final ColumnNameList _sourceColumns;
    private final TableName _targetTableName;
    private final ColumnNameList _targetColumns;
    private final MatchType _matchType;
    private final ReferentialAction _onDelete;
    private final ReferentialAction _onUpdate;

    public ForeignKeyConstraintImpl(ColumnNameList sourceColumns, TableName targetTableName, ColumnNameList targetColumns, MatchType matchType, ReferentialAction onDelete, ReferentialAction onUpdate) {
        this(ForeignKeyConstraint.class, sourceColumns, targetTableName, targetColumns, matchType, onDelete, onUpdate);
    }

    protected ForeignKeyConstraintImpl(Class<? extends ForeignKeyConstraint> realImplementingType, ColumnNameList sourceColumns, TableName targetTableName, ColumnNameList targetColumns, MatchType matchType, ReferentialAction onDelete, ReferentialAction onUpdate) {
        super(realImplementingType);
        NullArgumentException.validateNotNull((String)"Source columns", (Object)sourceColumns);
        NullArgumentException.validateNotNull((String)"Target table name", (Object)targetTableName);
        this._sourceColumns = sourceColumns;
        this._targetTableName = targetTableName;
        this._targetColumns = targetColumns;
        this._matchType = matchType;
        this._onDelete = onDelete;
        this._onUpdate = onUpdate;
    }

    protected boolean doesEqual(ForeignKeyConstraint another) {
        return this._targetTableName.equals(another.getTargetTableName()) && this._sourceColumns.equals(another.getSourceColumns()) && TypeableImpl.bothNullOrEquals((Object)this._targetColumns, (Object)another.getTargetColumns()) && TypeableImpl.bothNullOrEquals((Object)this._matchType, (Object)another.getMatchType()) && TypeableImpl.bothNullOrEquals((Object)this._onDelete, (Object)another.getOnDelete()) && TypeableImpl.bothNullOrEquals((Object)this._onUpdate, (Object)another.getOnUpdate());
    }

    public MatchType getMatchType() {
        return this._matchType;
    }

    public ReferentialAction getOnDelete() {
        return this._onDelete;
    }

    public ReferentialAction getOnUpdate() {
        return this._onUpdate;
    }

    public ColumnNameList getSourceColumns() {
        return this._sourceColumns;
    }

    public ColumnNameList getTargetColumns() {
        return this._targetColumns;
    }

    public TableName getTargetTableName() {
        return this._targetTableName;
    }
}

