/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.modification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.atp.spi.TypeableImpl;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.modification.SetClause;
import org.sql.generation.api.grammar.modification.TargetTable;
import org.sql.generation.api.grammar.modification.UpdateBySearch;
import org.sql.generation.api.grammar.modification.UpdateStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateBySearchImpl
extends TypeableImpl<UpdateStatement, UpdateBySearch>
implements UpdateBySearch {
    private final TargetTable _targetTable;
    private final List<SetClause> _setClauses;
    private final BooleanExpression _where;

    public UpdateBySearchImpl(TargetTable targetTable, List<SetClause> setClauses, BooleanExpression where) {
        this(UpdateBySearch.class, targetTable, setClauses, where);
    }

    protected UpdateBySearchImpl(Class<? extends UpdateBySearch> expressionClass, TargetTable targetTable, List<SetClause> setClauses, BooleanExpression where) {
        super(expressionClass);
        NullArgumentException.validateNotNull((String)"target table", (Object)targetTable);
        NullArgumentException.validateNotNull((String)"set clauses", setClauses);
        for (SetClause clause : setClauses) {
            NullArgumentException.validateNotNull((String)"set clause", (Object)clause);
        }
        this._targetTable = targetTable;
        this._setClauses = Collections.unmodifiableList(new ArrayList<SetClause>(setClauses));
        this._where = where;
    }

    public TargetTable getTargetTable() {
        return this._targetTable;
    }

    public BooleanExpression getWhere() {
        return this._where;
    }

    public List<SetClause> getSetClauses() {
        return this._setClauses;
    }

    protected boolean doesEqual(UpdateBySearch another) {
        return this._targetTable.equals(another.getTargetTable()) && ((Object)this._setClauses).equals(another.getSetClauses()) && TypeableImpl.bothNullOrEquals((Object)this._where, (Object)another.getWhere());
    }
}

