/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue609Test {
    CountDownLatch countDownLatch = new CountDownLatch(1);
    CountDownLatch countServerDownLatch = new CountDownLatch(1);
    boolean wasOpenClient;
    boolean wasOpenServer;

    @Test
    public void testIssue() throws Exception {
        int port = SocketUtil.getAvailablePort();
        WebSocketClient webSocket = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
                Issue609Test.this.wasOpenClient = this.isOpen();
                Issue609Test.this.countDownLatch.countDown();
            }

            public void onError(Exception ex) {
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                Issue609Test.this.wasOpenServer = conn.isOpen();
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                Issue609Test.this.countServerDownLatch.countDown();
            }
        };
        server.start();
        this.countServerDownLatch.await();
        webSocket.connectBlocking();
        Assert.assertTrue((String)"webSocket.isOpen()", (boolean)webSocket.isOpen());
        webSocket.getSocket().close();
        this.countDownLatch.await();
        Assert.assertTrue((String)"!webSocket.isOpen()", (!webSocket.isOpen() ? 1 : 0) != 0);
        Assert.assertTrue((String)"!wasOpenClient", (!this.wasOpenClient ? 1 : 0) != 0);
        Assert.assertTrue((String)"!wasOpenServer", (!this.wasOpenServer ? 1 : 0) != 0);
        server.stop();
    }
}

