/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.extensions;

import java.nio.ByteBuffer;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.extensions.permessage_deflate.PerMessageDeflateExtension;
import org.java_websocket.framing.ContinuousFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.TextFrame;
import org.junit.Assert;
import org.junit.Test;

public class PerMessageDeflateExtensionTest {
    @Test
    public void testDecodeFrame() throws InvalidDataException {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        String str = "This is a highly compressable textThis is a highly compressable textThis is a highly compressable textThis is a highly compressable textThis is a highly compressable text";
        byte[] message = str.getBytes();
        TextFrame frame = new TextFrame();
        frame.setPayload(ByteBuffer.wrap(message));
        deflateExtension.encodeFrame((Framedata)frame);
        deflateExtension.decodeFrame((Framedata)frame);
        Assert.assertArrayEquals((byte[])message, (byte[])frame.getPayloadData().array());
    }

    @Test
    public void testEncodeFrame() {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        String str = "This is a highly compressable textThis is a highly compressable textThis is a highly compressable textThis is a highly compressable textThis is a highly compressable text";
        byte[] message = str.getBytes();
        TextFrame frame = new TextFrame();
        frame.setPayload(ByteBuffer.wrap(message));
        deflateExtension.encodeFrame((Framedata)frame);
        Assert.assertTrue((message.length > frame.getPayloadData().array().length ? 1 : 0) != 0);
    }

    @Test
    public void testAcceptProvidedExtensionAsServer() {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        Assert.assertTrue((boolean)deflateExtension.acceptProvidedExtensionAsServer("permessage-deflate"));
        Assert.assertTrue((boolean)deflateExtension.acceptProvidedExtensionAsServer("some-other-extension, permessage-deflate"));
        Assert.assertFalse((boolean)deflateExtension.acceptProvidedExtensionAsServer("wrong-permessage-deflate"));
    }

    @Test
    public void testAcceptProvidedExtensionAsClient() {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        Assert.assertTrue((boolean)deflateExtension.acceptProvidedExtensionAsClient("permessage-deflate"));
        Assert.assertTrue((boolean)deflateExtension.acceptProvidedExtensionAsClient("some-other-extension, permessage-deflate"));
        Assert.assertFalse((boolean)deflateExtension.acceptProvidedExtensionAsClient("wrong-permessage-deflate"));
    }

    @Test
    public void testIsFrameValid() {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        TextFrame frame = new TextFrame();
        try {
            deflateExtension.isFrameValid((Framedata)frame);
            Assert.fail((String)"Frame not valid. RSV1 must be set.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        frame.setRSV1(true);
        try {
            deflateExtension.isFrameValid((Framedata)frame);
        }
        catch (Exception e) {
            Assert.fail((String)"Frame is valid.");
        }
        frame.setRSV2(true);
        try {
            deflateExtension.isFrameValid((Framedata)frame);
            Assert.fail((String)"Only RSV1 bit must be set.");
        }
        catch (Exception e) {
            // empty catch block
        }
        ContinuousFrame contFrame = new ContinuousFrame();
        contFrame.setRSV1(true);
        try {
            deflateExtension.isFrameValid((Framedata)contFrame);
            Assert.fail((String)"RSV1 must only be set for first fragments.Continuous frames can't have RSV1 bit set.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        contFrame.setRSV1(false);
        try {
            deflateExtension.isFrameValid((Framedata)contFrame);
        }
        catch (Exception e) {
            Assert.fail((String)"Continuous frame is valid.");
        }
    }

    @Test
    public void testGetProvidedExtensionAsClient() {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        Assert.assertEquals((Object)"permessage-deflate; server_no_context_takeover; client_no_context_takeover", (Object)deflateExtension.getProvidedExtensionAsClient());
    }

    @Test
    public void testGetProvidedExtensionAsServer() {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        Assert.assertEquals((Object)"permessage-deflate; server_no_context_takeover", (Object)deflateExtension.getProvidedExtensionAsServer());
    }

    @Test
    public void testToString() throws Exception {
        PerMessageDeflateExtension deflateExtension = new PerMessageDeflateExtension();
        Assert.assertEquals((Object)"PerMessageDeflateExtension", (Object)deflateExtension.toString());
    }
}

