/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import java.nio.ByteBuffer;
import org.java_websocket.enums.Opcode;
import org.java_websocket.framing.BinaryFrame;
import org.java_websocket.framing.CloseFrame;
import org.java_websocket.framing.ContinuousFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.FramedataImpl1;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.framing.PongFrame;
import org.java_websocket.framing.TextFrame;
import org.junit.Assert;
import org.junit.Test;

public class FramedataImpl1Test {
    @Test
    public void testDefaultValues() {
        FramedataImpl1 binary = FramedataImpl1.get((Opcode)Opcode.BINARY);
        Assert.assertEquals((String)"Opcode must be equal", (Object)Opcode.BINARY, (Object)binary.getOpcode());
        Assert.assertEquals((String)"Fin must be set", (Object)true, (Object)binary.isFin());
        Assert.assertEquals((String)"TransferedMask must not be set", (Object)false, (Object)binary.getTransfereMasked());
        Assert.assertEquals((String)"Payload must be empty", (long)0L, (long)binary.getPayloadData().capacity());
        Assert.assertEquals((String)"RSV1 must be false", (Object)false, (Object)binary.isRSV1());
        Assert.assertEquals((String)"RSV2 must be false", (Object)false, (Object)binary.isRSV2());
        Assert.assertEquals((String)"RSV3 must be false", (Object)false, (Object)binary.isRSV3());
    }

    @Test
    public void testGet() {
        FramedataImpl1 binary = FramedataImpl1.get((Opcode)Opcode.BINARY);
        Assert.assertEquals((String)"Frame must be binary", (Object)true, (Object)(binary instanceof BinaryFrame));
        FramedataImpl1 text = FramedataImpl1.get((Opcode)Opcode.TEXT);
        Assert.assertEquals((String)"Frame must be text", (Object)true, (Object)(text instanceof TextFrame));
        FramedataImpl1 closing = FramedataImpl1.get((Opcode)Opcode.CLOSING);
        Assert.assertEquals((String)"Frame must be closing", (Object)true, (Object)(closing instanceof CloseFrame));
        FramedataImpl1 continuous = FramedataImpl1.get((Opcode)Opcode.CONTINUOUS);
        Assert.assertEquals((String)"Frame must be continuous", (Object)true, (Object)(continuous instanceof ContinuousFrame));
        FramedataImpl1 ping = FramedataImpl1.get((Opcode)Opcode.PING);
        Assert.assertEquals((String)"Frame must be ping", (Object)true, (Object)(ping instanceof PingFrame));
        FramedataImpl1 pong = FramedataImpl1.get((Opcode)Opcode.PONG);
        Assert.assertEquals((String)"Frame must be pong", (Object)true, (Object)(pong instanceof PongFrame));
        try {
            FramedataImpl1.get(null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetters() {
        FramedataImpl1 frame = FramedataImpl1.get((Opcode)Opcode.BINARY);
        frame.setFin(false);
        Assert.assertEquals((String)"Fin must not be set", (Object)false, (Object)frame.isFin());
        frame.setTransferemasked(true);
        Assert.assertEquals((String)"TransferedMask must be set", (Object)true, (Object)frame.getTransfereMasked());
        ByteBuffer buffer = ByteBuffer.allocate(100);
        frame.setPayload(buffer);
        Assert.assertEquals((String)"Payload must be of size 100", (long)100L, (long)frame.getPayloadData().capacity());
        frame.setRSV1(true);
        Assert.assertEquals((String)"RSV1 must be true", (Object)true, (Object)frame.isRSV1());
        frame.setRSV2(true);
        Assert.assertEquals((String)"RSV2 must be true", (Object)true, (Object)frame.isRSV2());
        frame.setRSV3(true);
        Assert.assertEquals((String)"RSV3 must be true", (Object)true, (Object)frame.isRSV3());
    }

    @Test
    public void testAppend() {
        FramedataImpl1 frame0 = FramedataImpl1.get((Opcode)Opcode.BINARY);
        frame0.setFin(false);
        frame0.setPayload(ByteBuffer.wrap("first".getBytes()));
        FramedataImpl1 frame1 = FramedataImpl1.get((Opcode)Opcode.BINARY);
        frame1.setPayload(ByteBuffer.wrap("second".getBytes()));
        frame0.append((Framedata)frame1);
        Assert.assertEquals((String)"Fin must be set", (Object)true, (Object)frame0.isFin());
        Assert.assertArrayEquals((String)"Payload must be equal", (byte[])"firstsecond".getBytes(), (byte[])frame0.getPayloadData().array());
    }
}

