/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Test;

public class Issue900Test {
    CountDownLatch serverStartLatch = new CountDownLatch(1);
    CountDownLatch closeCalledLatch = new CountDownLatch(1);

    @Test(timeout=2000L)
    public void testIssue() throws Exception {
        int port = SocketUtil.getAvailablePort();
        WebSocketClient client = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                Issue900Test.this.closeCalledLatch.countDown();
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                Issue900Test.this.serverStartLatch.countDown();
            }
        };
        new Thread((Runnable)server).start();
        this.serverStartLatch.await();
        client.connectBlocking();
        WebSocketImpl websocketImpl = (WebSocketImpl)new ArrayList(server.getConnections()).get(0);
        websocketImpl.setChannel((ByteChannel)((Object)new ExceptionThrowingByteChannel()));
        server.broadcast("test");
        this.closeCalledLatch.await();
    }

    class ExceptionThrowingByteChannel
    implements WrappedByteChannel {
        ExceptionThrowingByteChannel() {
        }

        public boolean isNeedWrite() {
            return true;
        }

        public void writeMore() throws IOException {
            throw new IOException();
        }

        public boolean isNeedRead() {
            return true;
        }

        public int readMore(ByteBuffer dst) throws IOException {
            throw new IOException();
        }

        public boolean isBlocking() {
            return false;
        }

        public int read(ByteBuffer dst) throws IOException {
            throw new IOException();
        }

        public int write(ByteBuffer src) throws IOException {
            throw new IOException();
        }

        public boolean isOpen() {
            return false;
        }

        public void close() throws IOException {
            throw new IOException();
        }
    }
}

