/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.TextureCubeMap;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.TextureState;

public class TextureCubeMapState
extends TextureState {
    private int[][] ic = new int[6][];

    public TextureCubeMapState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            TextureCubeMap tcm = (TextureCubeMap)this.node;
            for (int face = 0; face < 6; ++face) {
                ImageComponent[] images = tcm.getImages(face);
                this.ic[face] = new int[images.length];
                for (int i = 0; i < images.length; ++i) {
                    this.ic[face][i] = control.getSymbolTable().addReference((SceneGraphObject)images[i]);
                }
            }
        }
    }

    @Override
    public void addSubReference() {
        for (int face = 0; face < 6; ++face) {
            for (int i = 0; i < this.ic[face].length; ++i) {
                this.control.getSymbolTable().incNodeComponentRefCount(this.ic[face][i]);
            }
        }
    }

    @Override
    public void buildGraph() {
        TextureCubeMap tcm = (TextureCubeMap)this.node;
        for (int face = 0; face < 6; ++face) {
            for (int i = 0; i < this.ic[face].length; ++i) {
                tcm.setImage(i, face, (ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.ic[face][i]));
            }
        }
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.mipMapMode), new Integer(this.format), new Integer(this.width), new Integer(this.boundaryWidth)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new TextureCubeMap(this.mipMapMode, this.format, this.width, this.boundaryWidth);
    }
}

