/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.scijava.Disposable;
import org.scijava.NoSuchServiceException;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginIndex;
import org.scijava.service.Service;
import org.scijava.service.ServiceHelper;
import org.scijava.service.ServiceIndex;
import org.scijava.util.ClassUtils;

public class Context
implements Disposable {
    private final ServiceIndex serviceIndex = new ServiceIndex();
    private final PluginIndex pluginIndex;

    public Context() {
        this(false);
    }

    public Context(boolean empty) {
        this(empty ? Collections.emptyList() : Arrays.asList(Service.class));
    }

    public Context(Class ... serviceClasses) {
        this(serviceClasses != null ? Arrays.asList(serviceClasses) : Arrays.asList(Service.class));
    }

    public Context(Collection<Class<? extends Service>> serviceClasses) {
        this(serviceClasses, new PluginIndex());
    }

    public Context(PluginIndex pluginIndex) {
        this(Arrays.asList(Service.class), pluginIndex);
    }

    public Context(Collection<Class<? extends Service>> serviceClasses, PluginIndex pluginIndex) {
        this.pluginIndex = pluginIndex;
        pluginIndex.discover();
        ServiceHelper serviceHelper = new ServiceHelper(this, serviceClasses);
        serviceHelper.loadServices();
    }

    public ServiceIndex getServiceIndex() {
        return this.serviceIndex;
    }

    public PluginIndex getPluginIndex() {
        return this.pluginIndex;
    }

    public <S extends Service> S service(Class<S> c) {
        S service = this.getService(c);
        if (service == null) {
            throw new NoSuchServiceException("Service " + c.getName() + " not found.");
        }
        return service;
    }

    public Service service(String className) {
        Class<?> c = ClassUtils.loadClass(className);
        if (c == null) {
            throw new IllegalArgumentException("No such class: " + className);
        }
        if (!Service.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Not a service class: " + c.getName());
        }
        Class<?> serviceClass = c;
        return this.service(serviceClass);
    }

    public <S extends Service> S getService(Class<S> c) {
        return this.serviceIndex.getService(c);
    }

    public Service getService(String className) {
        Class<?> c = ClassUtils.loadClass(className);
        if (c == null) {
            return null;
        }
        if (!Service.class.isAssignableFrom(c)) {
            return null;
        }
        Class<?> serviceClass = c;
        return this.getService(serviceClass);
    }

    public void inject(Object o) {
        List<Field> fields = ClassUtils.getAnnotatedFields(o.getClass(), Parameter.class);
        for (Field f : fields) {
            f.setAccessible(true);
            Class<?> type = f.getType();
            if (Service.class.isAssignableFrom(type)) {
                Service existingService = (Service)ClassUtils.getValue(f, o);
                if (existingService != null) {
                    throw new IllegalStateException("Context already injected: " + f.getDeclaringClass().getName() + "#" + f.getName());
                }
                Class<?> serviceType = type;
                Object service = this.getService(serviceType);
                if (service == null && f.getAnnotation(Parameter.class).required()) {
                    throw new IllegalArgumentException(this.createMissingServiceMessage(serviceType));
                }
                ClassUtils.setValue(f, o, service);
                continue;
            }
            if (!type.isAssignableFrom(this.getClass())) continue;
            Context existingContext = (Context)ClassUtils.getValue(f, o);
            if (existingContext != null) {
                throw new IllegalStateException("Context already injected: " + f.getDeclaringClass().getName() + "#" + f.getName());
            }
            ClassUtils.setValue(f, o, this);
        }
        EventService eventService = this.getService(EventService.class);
        if (eventService != null) {
            eventService.subscribe(o);
        }
    }

    @Override
    public void dispose() {
        List services = this.serviceIndex.getAll();
        for (int s = services.size() - 1; s >= 0; --s) {
            ((Service)services.get(s)).dispose();
        }
    }

    private String createMissingServiceMessage(Class<? extends Service> serviceType) {
        String nl = System.getProperty("line.separator");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        StringBuilder msg = new StringBuilder("Required service is missing: " + serviceType.getName() + nl);
        msg.append("Context: " + this + nl);
        msg.append("ClassLoader: " + classLoader + nl);
        msg.append(nl + "-- Services known to context --" + nl);
        for (Service knownService : this.serviceIndex.getAll()) {
            msg.append(knownService + nl);
        }
        msg.append(nl + "-- Classpath of ClassLoader --" + nl);
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                msg.append(url.getPath() + nl);
            }
        } else {
            msg.append("ClassLoader was not a URLClassLoader. Could not print classpath.");
        }
        return msg.toString();
    }
}

