/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scijava.util.ArrayUtils;
import org.scijava.util.ClassUtils;

public class ConversionUtils {
    private ConversionUtils() {
    }

    public static Object convert(Object src, Type dest) {
        Class<?> c = ConversionUtils.getClass(dest);
        if (c != null && ConversionUtils.canCast(src, c)) {
            return ConversionUtils.cast(src, c);
        }
        if (ConversionUtils.isArray(dest)) {
            return ConversionUtils.convertToArray(src, ConversionUtils.getComponentClass(dest));
        }
        if (dest instanceof ParameterizedType && ConversionUtils.isCollection(dest)) {
            return ConversionUtils.convertToCollection(src, (ParameterizedType)dest);
        }
        return ConversionUtils.convert(src, ConversionUtils.getClass(dest));
    }

    public static <T> T convert(Object src, Class<T> dest) {
        String result;
        if (dest == null) {
            return null;
        }
        if (src == null) {
            return ConversionUtils.getNullValue(dest);
        }
        Class<T> saneDest = ConversionUtils.getNonprimitiveType(dest);
        if (ConversionUtils.canCast(src, saneDest)) {
            return ConversionUtils.cast(src, saneDest);
        }
        if (src instanceof Number) {
            Number number = (Number)src;
            if (saneDest == Byte.class) {
                Byte result2;
                Byte typedResult = result2 = Byte.valueOf(number.byteValue());
                return (T)typedResult;
            }
            if (saneDest == Double.class) {
                Double result3;
                Double typedResult = result3 = Double.valueOf(number.doubleValue());
                return (T)typedResult;
            }
            if (saneDest == Float.class) {
                Float result4;
                Float typedResult = result4 = Float.valueOf(number.floatValue());
                return (T)typedResult;
            }
            if (saneDest == Integer.class) {
                Integer result5;
                Integer typedResult = result5 = Integer.valueOf(number.intValue());
                return (T)typedResult;
            }
            if (saneDest == Long.class) {
                Long result6;
                Long typedResult = result6 = Long.valueOf(number.longValue());
                return (T)typedResult;
            }
            if (saneDest == Short.class) {
                Short result7;
                Short typedResult = result7 = Short.valueOf(number.shortValue());
                return (T)typedResult;
            }
        }
        if (src instanceof String) {
            String s = (String)src;
            if (s.isEmpty()) {
                return ConversionUtils.getNullValue(dest);
            }
            if (saneDest == Character.class) {
                Character c;
                Character result8 = c = new Character(s.charAt(0));
                return (T)result8;
            }
            if (dest.isEnum() && (result = ConversionUtils.convertToEnum(s, dest)) != null) {
                return (T)result;
            }
        }
        if (saneDest == String.class) {
            String sValue;
            result = sValue = src.toString();
            return (T)result;
        }
        try {
            Constructor<?> ctor = ConversionUtils.getConstructor(saneDest, src.getClass());
            if (ctor == null) {
                return null;
            }
            Object instance = ctor.newInstance(src);
            return (T)instance;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static <T> T convertToEnum(String src, Class<T> dest) {
        if (src == null || !dest.isEnum()) {
            return null;
        }
        try {
            T result;
            T typedResult = result = Enum.valueOf(dest, src);
            return typedResult;
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public static boolean canConvert(Class<?> src, Type dest) {
        Class<?> c = ConversionUtils.getClass(dest);
        if (c != null && ConversionUtils.canCast(src, c)) {
            return true;
        }
        if (ConversionUtils.isArray(dest)) {
            return true;
        }
        if (dest instanceof ParameterizedType && ConversionUtils.isCollection(dest)) {
            return ConversionUtils.createCollection(ConversionUtils.getClass(dest)) != null;
        }
        return ConversionUtils.canConvert(src, ConversionUtils.getClass(dest));
    }

    public static boolean canConvert(Class<?> src, Class<?> dest) {
        Class<?> saneDest = ConversionUtils.getNonprimitiveType(dest);
        if (ConversionUtils.canCast(src, saneDest)) {
            return true;
        }
        if (ConversionUtils.canCast(ConversionUtils.getNonprimitiveType(src), Number.class) && (ClassUtils.isByte(dest) || ClassUtils.isDouble(dest) || ClassUtils.isFloat(dest) || ClassUtils.isInteger(dest) || ClassUtils.isLong(dest) || ClassUtils.isShort(dest))) {
            return true;
        }
        if (saneDest == String.class) {
            return true;
        }
        if (ConversionUtils.canCast(src, String.class)) {
            if (saneDest == Character.class) {
                return true;
            }
            if (dest.isEnum()) {
                return true;
            }
        }
        try {
            return ConversionUtils.getConstructor(saneDest, src) != null;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean canConvert(Object src, Type dest) {
        if (src == null) {
            return true;
        }
        return ConversionUtils.canConvert(src.getClass(), dest);
    }

    public static boolean canConvert(Object src, Class<?> dest) {
        if (src == null) {
            return true;
        }
        return ConversionUtils.canConvert(src.getClass(), dest);
    }

    public static <T> T cast(Object src, Class<T> dest) {
        if (!ConversionUtils.canCast(src, dest)) {
            return null;
        }
        Object result = src;
        return (T)result;
    }

    public static boolean canCast(Class<?> src, Class<?> dest) {
        return dest.isAssignableFrom(src);
    }

    public static boolean canCast(Object src, Class<?> dest) {
        return src == null || ConversionUtils.canCast(src.getClass(), dest);
    }

    public static <T> Class<T> getNonprimitiveType(Class<T> type) {
        Class destType = type == Boolean.TYPE ? Boolean.class : (type == Byte.TYPE ? Byte.class : (type == Character.TYPE ? Character.class : (type == Double.TYPE ? Double.class : (type == Float.TYPE ? Float.class : (type == Integer.TYPE ? Integer.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Void.TYPE ? Void.class : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> T getNullValue(Class<T> type) {
        Serializable defaultValue = type == Boolean.TYPE ? Boolean.valueOf(false) : (type == Byte.TYPE ? Byte.valueOf((byte)0) : (type == Character.TYPE ? (Serializable)Character.valueOf('\u0000') : (Serializable)(type == Double.TYPE ? (Number)0.0 : (Number)(type == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(type == Integer.TYPE ? (Number)0 : (Number)(type == Long.TYPE ? (Number)0L : (Number)(type == Short.TYPE ? Short.valueOf((short)0) : null)))))));
        Boolean result = defaultValue;
        return (T)result;
    }

    public static Class<?> getClass(Type type) {
        Type[] types;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConversionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable && (types = ((TypeVariable)type).getBounds()).length == 1) {
            return ConversionUtils.getClass(types[0]);
        }
        return null;
    }

    public static Class<?> getComponentClass(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ConversionUtils.getClass(((GenericArrayType)type).getGenericComponentType());
        }
        return null;
    }

    private static Constructor<?> getConstructor(Class<?> type, Class<?> argType) {
        for (Constructor<?> ctor : type.getConstructors()) {
            Class<?>[] params = ctor.getParameterTypes();
            if (params.length != 1 || !ConversionUtils.canCast(argType, params[0])) continue;
            return ctor;
        }
        return null;
    }

    private static boolean isArray(Type type) {
        return ConversionUtils.getComponentClass(type) != null;
    }

    private static boolean isCollection(Type type) {
        return ConversionUtils.canCast(ConversionUtils.getClass(type), Collection.class);
    }

    private static Object convertToArray(Object value, Class<?> componentType) {
        Collection<?> items = ArrayUtils.toCollection(value);
        Object array = Array.newInstance(componentType, items.size());
        int index = 0;
        for (Object item : items) {
            Array.set(array, index++, ConversionUtils.convert(item, componentType));
        }
        return array;
    }

    private static Object convertToCollection(Object value, ParameterizedType pType) {
        Collection<Object> collection = ConversionUtils.createCollection(ConversionUtils.getClass(pType));
        if (collection == null) {
            return null;
        }
        Collection<?> items = ArrayUtils.toCollection(value);
        Type collectionType = pType.getActualTypeArguments()[0];
        for (Object item : items) {
            collection.add(ConversionUtils.convert(item, collectionType));
        }
        return collection;
    }

    private static Collection<Object> createCollection(Class<?> type) {
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            if (ConversionUtils.canCast(type, List.class)) {
                return new ArrayList<Object>();
            }
            if (ConversionUtils.canCast(type, Set.class)) {
                return new HashSet<Object>();
            }
            return null;
        }
        try {
            Collection c = (Collection)type.newInstance();
            return c;
        }
        catch (InstantiationException exc) {
            return null;
        }
        catch (IllegalAccessException exc) {
            return null;
        }
    }
}

