/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.Optional;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.log.StderrLogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.service.Service;
import org.scijava.service.event.ServicesLoadedEvent;
import org.scijava.util.ClassUtils;

public class ServiceHelper
extends AbstractContextual {
    private LogService log;
    private final Map<Class<? extends Service>, Double> classPoolMap;
    private final List<Class<? extends Service>> classPoolList;
    private final List<Class<? extends Service>> serviceClasses;

    public ServiceHelper(Context context) {
        this(context, null);
    }

    public ServiceHelper(Context context, Collection<Class<? extends Service>> serviceClasses) {
        this.setContext(context);
        this.log = context.getService(LogService.class);
        if (this.log == null) {
            this.log = new StderrLogService();
        }
        this.classPoolMap = new HashMap<Class<? extends Service>, Double>();
        this.classPoolList = new ArrayList<Class<? extends Service>>();
        this.findServiceClasses(this.classPoolMap, this.classPoolList);
        if (this.classPoolList.isEmpty()) {
            this.log.warn("Class pool is empty: forgot to call Thread#setClassLoader?");
        }
        this.serviceClasses = new ArrayList<Class<? extends Service>>();
        if (serviceClasses == null) {
            this.serviceClasses.addAll(this.classPoolList);
        } else {
            this.serviceClasses.addAll(serviceClasses);
        }
    }

    public void loadServices() {
        for (Class<? extends Service> serviceClass : this.serviceClasses) {
            LogService logService;
            for (Class<? extends Service> c : this.classPoolList) {
                if (!serviceClass.isAssignableFrom(c)) continue;
                this.loadService(c);
            }
            this.loadService(serviceClass);
            if (!LogService.class.isAssignableFrom(serviceClass) || (logService = this.context().getService(LogService.class)) == null) continue;
            this.log = logService;
        }
        EventService eventService = this.context().getService(EventService.class);
        if (eventService != null) {
            eventService.publishLater(new ServicesLoadedEvent());
        }
    }

    public <S extends Service> S loadService(Class<S> c) {
        return this.loadService(c, !this.isOptional(c));
    }

    public <S extends Service> S createExactService(Class<S> c) {
        return this.createExactService(c, false);
    }

    private <S extends Service> S loadService(Class<S> c, boolean required) {
        S service = this.context().getService(c);
        if (service != null) {
            return service;
        }
        for (Class<? extends Service> serviceClass : this.classPoolList) {
            if (!c.isAssignableFrom(serviceClass)) continue;
            Service result = this.createExactService(serviceClass, required);
            if (required && result == null) {
                throw new IllegalArgumentException();
            }
            return (S)result;
        }
        if (required && c.isInterface()) {
            throw new IllegalArgumentException("No compatible service: " + c.getName());
        }
        return this.createExactService(c, required);
    }

    private <S extends Service> S createExactService(Class<S> c, boolean required) {
        String name = c.getName();
        this.log.debug("Creating service: " + name, null);
        try {
            long start = 0L;
            long end = 0L;
            boolean debug = this.log.isDebug();
            if (debug) {
                start = System.currentTimeMillis();
            }
            S service = this.createServiceRecursively(c);
            this.context().getServiceIndex().add(service);
            if (debug) {
                end = System.currentTimeMillis();
                this.log.debug("Created service '" + name + "' in " + (end - start) + " ms");
            }
            return service;
        }
        catch (Throwable t) {
            if (required) {
                throw new IllegalArgumentException("Invalid service: " + name, t);
            }
            if (this.log.isDebug()) {
                this.log.debug("Invalid service: " + name, t);
            } else {
                this.log.warn("Invalid service: " + name);
            }
            return null;
        }
    }

    private <S extends Service> S createServiceRecursively(Class<S> c) throws InstantiationException, IllegalAccessException {
        Service service = (Service)c.newInstance();
        service.setContext(this.getContext());
        Double priority = this.classPoolMap.get(c);
        if (priority != null) {
            service.setPriority(priority);
        }
        List<Field> fields = ClassUtils.getAnnotatedFields(c, Parameter.class);
        for (Field f : fields) {
            f.setAccessible(true);
            Class<?> type = f.getType();
            if (type.isAssignableFrom(this.context().getClass())) {
                ClassUtils.setValue(f, service, this.getContext());
                continue;
            }
            if (!Service.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("Invalid parameter: " + f.getDeclaringClass().getName() + "#" + f.getName());
            }
            Class<?> serviceType = type;
            Object s = this.context().getService(serviceType);
            if (s == null) {
                boolean required = f.getAnnotation(Parameter.class).required();
                s = this.loadService(serviceType, required);
            }
            ClassUtils.setValue(f, service, s);
        }
        service.initialize();
        service.registerEventHandlers();
        return (S)service;
    }

    private void findServiceClasses(Map<Class<? extends Service>, Double> serviceMap, List<Class<? extends Service>> serviceList) {
        List<PluginInfo<Service>> services = this.context().getPluginIndex().getPlugins(Service.class);
        for (PluginInfo<Service> info : services) {
            try {
                Class<Service> c = info.loadClass();
                double priority = info.getPriority();
                serviceMap.put(c, priority);
                serviceList.add(c);
            }
            catch (Throwable e) {
                this.log.error("Invalid service: " + info, e);
            }
        }
    }

    private boolean isOptional(Class<?> c) {
        return Optional.class.isAssignableFrom(c);
    }
}

