/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.console;

import java.util.LinkedList;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;

@Plugin(type=ConsoleArgument.class)
public class UIArgument
extends AbstractConsoleArgument {
    @Parameter
    private UIService uiService;
    @Parameter
    private LogService log;

    @Override
    public void handle(LinkedList<String> args) {
        if (!this.supports(args)) {
            return;
        }
        args.removeFirst();
        String uiName = args.removeFirst();
        UserInterface ui = this.uiService.getUI(uiName);
        if (ui == null) {
            this.log.error("No such UI: " + uiName);
        } else {
            this.uiService.setDefaultUI(ui);
        }
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        return args != null && args.size() >= 2 && args.getFirst().equals("--ui");
    }
}

