/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.thread;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public final class DefaultThreadService
extends AbstractService
implements ThreadService {
    private static final String SCIJAVA_THREAD_PREFIX = "SciJava-";
    private static WeakHashMap<Thread, Thread> parents = new WeakHashMap();
    @Parameter
    private LogService log;
    private ExecutorService executor;
    private int nextThread = 0;
    private boolean disposed;

    @Override
    public <V> Future<V> run(Callable<V> code) {
        if (this.disposed) {
            return null;
        }
        return this.executor().submit(this.wrap(code));
    }

    @Override
    public Future<?> run(Runnable code) {
        if (this.disposed) {
            return null;
        }
        return this.executor().submit(this.wrap(code));
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executor();
    }

    @Override
    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void invoke(Runnable code) throws InterruptedException, InvocationTargetException {
        if (this.isDispatchThread()) {
            code.run();
        } else {
            EventQueue.invokeAndWait(this.wrap(code));
        }
    }

    @Override
    public void queue(Runnable code) {
        EventQueue.invokeLater(this.wrap(code));
    }

    @Override
    public Thread getParent(Thread thread) {
        return parents.get(thread != null ? thread : Thread.currentThread());
    }

    @Override
    public ThreadService.ThreadContext getThreadContext(Thread thread) {
        String name = thread.getName();
        if (name.startsWith(this.contextThreadPrefix())) {
            return ThreadService.ThreadContext.SAME;
        }
        if (name.startsWith(SCIJAVA_THREAD_PREFIX)) {
            return ThreadService.ThreadContext.OTHER;
        }
        Thread parent = this.getParent(thread);
        if (parent == thread || parent == null) {
            return ThreadService.ThreadContext.NONE;
        }
        return this.getThreadContext(parent);
    }

    @Override
    public void dispose() {
        this.disposed = true;
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        String threadName = this.contextThreadPrefix() + this.nextThread++;
        return new Thread(r, threadName);
    }

    private ExecutorService executor() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool(this);
        }
        return this.executor;
    }

    private Runnable wrap(final Runnable r) {
        final Thread parent = Thread.currentThread();
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                try {
                    if (parent != thread) {
                        parents.put(thread, parent);
                    }
                    r.run();
                }
                finally {
                    if (parent != thread) {
                        parents.remove(thread);
                    }
                }
            }
        };
    }

    private <V> Callable<V> wrap(final Callable<V> c) {
        final Thread parent = Thread.currentThread();
        return new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                Thread thread = Thread.currentThread();
                try {
                    if (parent != thread) {
                        parents.put(thread, parent);
                    }
                    Object v = c.call();
                    return v;
                }
                finally {
                    if (parent != thread) {
                        parents.remove(thread);
                    }
                }
            }
        };
    }

    private String contextThreadPrefix() {
        String contextHash = Integer.toHexString(this.context().hashCode());
        return SCIJAVA_THREAD_PREFIX + contextHash + "-Thread-";
    }
}

