/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class MultiOutputStream
extends OutputStream {
    private final ArrayList<OutputStream> streams;
    private OutputStream[] cachedStreams;

    public MultiOutputStream(OutputStream ... os) {
        this.streams = new ArrayList(os.length);
        for (int i = 0; i < os.length; ++i) {
            this.streams.add(os[i]);
        }
        this.cacheStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputStream(OutputStream os) {
        ArrayList<OutputStream> arrayList = this.streams;
        synchronized (arrayList) {
            this.streams.add(os);
            this.cacheStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputStream(OutputStream os) {
        ArrayList<OutputStream> arrayList = this.streams;
        synchronized (arrayList) {
            this.streams.remove(os);
            this.cacheStreams();
        }
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream[] toWrite;
        for (OutputStream stream : toWrite = this.cachedStreams) {
            stream.write(b);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        OutputStream[] toWrite;
        for (OutputStream stream : toWrite = this.cachedStreams) {
            stream.write(buf, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        OutputStream[] toClose;
        for (OutputStream stream : toClose = this.cachedStreams) {
            stream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        OutputStream[] toFlush;
        for (OutputStream stream : toFlush = this.cachedStreams) {
            stream.flush();
        }
    }

    private void cacheStreams() {
        this.cachedStreams = this.streams.toArray(new OutputStream[this.streams.size()]);
    }
}

