/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginIndex;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;

public class PluginInfoTest {
    @Test
    public void testNames() throws InstantiableException {
        Context context = new Context(true);
        PluginIndex pluginIndex = context.getPluginIndex();
        List infos = pluginIndex.get(IceCream.class);
        Assert.assertEquals((long)3L, (long)infos.size());
        this.assertPlugin(Chocolate.class, IceCream.class, "chocolate", (PluginInfo)infos.get(0));
        this.assertPlugin(Vanilla.class, IceCream.class, "vanilla", (PluginInfo)infos.get(1));
        this.assertPlugin(Flavorless.class, IceCream.class, "", (PluginInfo)infos.get(2));
    }

    private void assertPlugin(Class<?> pluginClass, Class<?> pluginType, String name, PluginInfo<?> info) throws InstantiableException {
        Assert.assertSame(pluginClass, (Object)info.loadClass());
        Assert.assertSame(pluginType, (Object)info.getPluginType());
        Assert.assertEquals((Object)name, (Object)info.getName());
    }

    @Plugin(type=IceCream.class, name="chocolate", priority=10000.0)
    public static class Chocolate
    implements IceCream {
    }

    @Plugin(type=IceCream.class, name="vanilla", priority=-100.0)
    public static class Vanilla
    implements SciJavaPlugin {
    }

    @Plugin(type=IceCream.class, priority=-10000.0)
    public static class Flavorless
    implements SciJavaPlugin {
    }

    public static interface IceCream
    extends SciJavaPlugin {
    }
}

