/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.display.Display;
import org.scijava.ui.AbstractUserInterface;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;
import org.scijava.ui.headlessUI.HeadlessUI;
import org.scijava.ui.viewer.DisplayWindow;

public class UIServiceTest {
    private Context context;
    private UIService uiService;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{UIService.class});
        this.uiService = (UIService)this.context.service(UIService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testDefaultUI() {
        Assert.assertTrue((boolean)(this.uiService.getDefaultUI() instanceof HeadlessUI));
    }

    @Test
    public void testAvailableUIs() {
        List uiList = this.uiService.getAvailableUIs();
        Assert.assertEquals((long)1L, (long)uiList.size());
        Assert.assertTrue((boolean)(uiList.get(0) instanceof HeadlessUI));
    }

    @Test
    public void testHeadlessUI() {
        MockUserInterface mockUI = new MockUserInterface();
        this.uiService.setDefaultUI((UserInterface)mockUI);
        this.uiService.setHeadless(false);
        Assert.assertFalse((boolean)this.uiService.isHeadless());
        Assert.assertTrue((boolean)(this.uiService.getDefaultUI() instanceof MockUserInterface));
        this.uiService.setHeadless(true);
        Assert.assertTrue((boolean)this.uiService.isHeadless());
        Assert.assertTrue((String)"UIService should return HeadlessUI when running \"headless\"", (boolean)(this.uiService.getDefaultUI() instanceof HeadlessUI));
    }

    private static final class MockUserInterface
    extends AbstractUserInterface {
        private MockUserInterface() {
        }

        public DisplayWindow createDisplayWindow(Display<?> display) {
            return null;
        }

        public DialogPrompt dialogPrompt(String message, String title, DialogPrompt.MessageType messageType, DialogPrompt.OptionType optionType) {
            return null;
        }

        public void showContextMenu(String menuRoot, Display<?> display, int x, int y) {
        }

        public boolean requiresEDT() {
            return false;
        }

        public void dispose() {
        }
    }
}

