/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script.process;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.plugin.PTService;
import org.scijava.script.ScriptInfo;
import org.scijava.script.process.ScriptProcessor;
import org.scijava.service.SciJavaService;

public interface ScriptProcessorService
extends PTService<ScriptProcessor>,
SciJavaService {
    default public String process(ScriptInfo info) throws IOException {
        List processors = this.getPlugins().stream().map(p -> (ScriptProcessor)this.pluginService().createInstance(p)).collect(Collectors.toList());
        BufferedReader reader = info.getReader();
        if (reader == null) {
            reader = new BufferedReader(new FileReader(info.getPath()));
        }
        for (ScriptProcessor p2 : processors) {
            p2.begin(info);
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = reader;){
            String line;
            while ((line = in.readLine()) != null) {
                for (ScriptProcessor p3 : processors) {
                    line = p3.process(line);
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        for (ScriptProcessor p4 : processors) {
            p4.end();
        }
        return sb.toString();
    }

    @Override
    default public Class<ScriptProcessor> getPluginType() {
        return ScriptProcessor.class;
    }
}

