/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.util.DebugUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.Types;

public final class AppUtils {
    private static final Class<?> mainClass;

    private AppUtils() {
    }

    public static Class<?> getMainClass() {
        return mainClass;
    }

    public static File getBaseDirectory(String sysProp, Class<?> c, String baseSubdirectory) {
        File dir;
        String property = System.getProperty(sysProp);
        if (property != null && (dir = new File(property)).isDirectory()) {
            return dir;
        }
        File basePath = AppUtils.getBaseDirectory(c, baseSubdirectory);
        if (basePath != null) {
            return basePath;
        }
        File appPath = AppUtils.getBaseDirectory(AppUtils.getMainClass());
        if (appPath != null) {
            return appPath;
        }
        return new File(".").getAbsoluteFile();
    }

    public static File getBaseDirectory(Class<?> c) {
        return AppUtils.getBaseDirectory(c, null);
    }

    public static File getBaseDirectory(Class<?> c, String baseSubdirectory) {
        File baseFile;
        URL location = Types.location(c);
        try {
            baseFile = FileUtils.urlToFile(location);
        }
        catch (IllegalArgumentException exc) {
            baseFile = null;
        }
        return AppUtils.getBaseDirectory(baseFile, baseSubdirectory);
    }

    public static File getBaseDirectory(File classLocation, String baseSubdirectory) {
        String[] suffixes;
        if (classLocation == null) {
            return null;
        }
        String path = FileUtils.getPath(classLocation).replace('\\', '/');
        if (path.contains("/.m2/repository/")) {
            return null;
        }
        String basePrefix = "/";
        if (baseSubdirectory != null) {
            basePrefix = basePrefix + baseSubdirectory + "/";
        }
        String targetClassesSuffix = basePrefix + "target/classes";
        String targetTestClassesSuffix = basePrefix + "target/test-classes";
        for (String suffix : suffixes = new String[]{targetClassesSuffix, targetTestClassesSuffix}) {
            if (!path.endsWith(suffix)) continue;
            path = path.substring(0, path.length() - suffix.length());
            File dir = new File(path);
            if (baseSubdirectory == null) {
                while (dir.getParentFile() != null && new File(dir.getParentFile(), "pom.xml").exists()) {
                    dir = dir.getParentFile();
                }
            }
            return dir;
        }
        Pattern pattern = Pattern.compile(".*(" + Pattern.quote(basePrefix + "target/") + "[^/]*\\.jar)");
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            int index = matcher.start(1);
            path = path.substring(0, index);
            return new File(path);
        }
        if (path.endsWith(".jar")) {
            File jarDirectory = classLocation.getParentFile();
            return jarDirectory.getParentFile();
        }
        return classLocation;
    }

    static {
        String className = DebugUtils.getMainClassName();
        mainClass = className == null ? null : Types.load(className);
    }
}

