/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.convert.ArrayToStringConverter;
import org.scijava.convert.ConvertService;
import org.scijava.convert.StringToArrayConverter;
import org.scijava.parse.ParseService;

public class ArrayToStringConverterTest {
    private final ArrayToStringConverter converter = new ArrayToStringConverter();
    private Context context;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ConvertService.class, ParseService.class});
        this.context.inject((Object)this.converter);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testArrayConversion() {
        List<Object> arrays = Arrays.asList(new byte[]{1, 2, 3}, new Byte[]{(byte)1, (byte)2, (byte)3}, new short[]{1, 2, 3}, new Short[]{(short)1, (short)2, (short)3}, new int[]{1, 2, 3}, new Integer[]{1, 2, 3}, new long[]{1L, 2L, 3L}, new Long[]{1L, 2L, 3L}, new float[]{1.0f, 2.0f, 3.0f}, new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}, new double[]{1.0, 2.0, 3.0}, new Double[]{1.0, 2.0, 3.0});
        String sInt = "{1, 2, 3}";
        String sFloat = "{1.0, 2.0, 3.0}";
        for (Object array : arrays) {
            Assert.assertTrue((boolean)this.converter.canConvert(array, String.class));
            String converted = (String)this.converter.convert(array, String.class);
            Assert.assertTrue((converted.equals(sInt) || converted.equals(sFloat) ? 1 : 0) != 0);
        }
    }

    @Test
    public void test2DArrayConversion() {
        byte[][] arr = new byte[][]{{0, 1}, {2, 3}};
        Assert.assertTrue((boolean)this.converter.canConvert((Object)arr, String.class));
        String actual = (String)this.converter.convert((Object)arr, String.class);
        String expected = "{{0, 1}, {2, 3}}";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test3DArrayConversion() {
        byte[][][] arr = new byte[2][2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    arr[i][j][k] = (byte)(i + j + k);
                }
            }
        }
        Assert.assertTrue((boolean)this.converter.canConvert((Object)arr, String.class));
        String actual = (String)this.converter.convert((Object)arr, String.class);
        String expected = "{{{0, 1}, {1, 2}}, {{1, 2}, {2, 3}}}";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testEmptyArrayConversion() {
        byte[] arr = new byte[]{};
        Assert.assertTrue((boolean)this.converter.canConvert((Object)arr, String.class));
        String actual = (String)this.converter.convert((Object)arr, String.class);
        String expected = "{}";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCyclicConversion() {
        byte[] expected = new byte[]{1, 2, 3};
        ArrayToStringConverter c1 = new ArrayToStringConverter();
        this.context.inject((Object)c1);
        String converted = (String)c1.convert((Object)expected, String.class);
        StringToArrayConverter c2 = new StringToArrayConverter();
        this.context.inject((Object)c2);
        byte[] actual = (byte[])c2.convert((Object)converted, byte[].class);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testNullConversion() {
        String[] s1 = new String[]{null};
        String[] s2 = new String[]{"null"};
        String[] expected = new String[]{null};
        ArrayToStringConverter c1 = new ArrayToStringConverter();
        this.context.inject((Object)c1);
        String converted = (String)c1.convert((Object)expected, String.class);
        StringToArrayConverter c2 = new StringToArrayConverter();
        this.context.inject((Object)c2);
        String[] actual = (String[])c2.convert((Object)converted, String[].class);
        Assert.assertNull((Object)actual);
    }
}

