/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import java.net.URISyntaxException;
import org.scijava.io.IOPlugin;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.HandlerService;
import org.scijava.service.SciJavaService;

public interface TypedIOService<D>
extends HandlerService<Location, IOPlugin<D>>,
SciJavaService {
    default public IOPlugin<D> getOpener(String source) {
        try {
            return this.getOpener(this.context().service(LocationService.class).resolve(source));
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    default public IOPlugin<D> getOpener(Location source) {
        for (IOPlugin handler : this.getInstances()) {
            if (!handler.supportsOpen(source)) continue;
            return handler;
        }
        return null;
    }

    default public IOPlugin<D> getSaver(D data, String destination) {
        try {
            return this.getSaver(data, this.context().service(LocationService.class).resolve(destination));
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    default public IOPlugin<D> getSaver(D data, Location destination) {
        for (IOPlugin handler : this.getInstances()) {
            if (!handler.supportsSave(data, destination)) continue;
            return handler;
        }
        return null;
    }

    public D open(String var1) throws IOException;

    public D open(Location var1) throws IOException;

    public void save(D var1, String var2) throws IOException;

    public void save(D var1, Location var2) throws IOException;

    public boolean canOpen(String var1);

    public boolean canOpen(Location var1);

    public boolean canSave(D var1, String var2);

    public boolean canSave(D var1, Location var2);

    @Override
    default public Class<IOPlugin<D>> getPluginType() {
        return IOPlugin.class;
    }

    @Override
    default public Class<Location> getType() {
        return Location.class;
    }
}

