/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event.bushe;

import java.io.PrintStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.scijava.event.bushe.DataRequestEvent;

public class GenericReflection {
    DataRequestEvent dre;
    private static final PrintStream out = System.out;

    public static void printSuperclass(Type sup) {
        if (sup != null && !sup.equals(Object.class)) {
            out.print("extends ");
            GenericReflection.printType(sup);
            out.println();
        }
    }

    public static void printInterfaces(Type[] implementations) {
        if (implementations != null && implementations.length > 0) {
            out.print("implements ");
            int i = 0;
            for (Type impl : implementations) {
                if (i++ > 0) {
                    out.print(",");
                }
                GenericReflection.printType(impl);
            }
            out.println();
        }
    }

    public static void printTypeParameters(TypeVariable<?>[] vars) {
        if (vars != null && vars.length > 0) {
            out.print("<");
            int i = 0;
            for (TypeVariable<?> var : vars) {
                if (i++ > 0) {
                    out.print(",");
                }
                out.print(var.getName());
                GenericReflection.printBounds(var.getBounds());
            }
            out.print(">");
        }
    }

    public static void printBounds(Type[] bounds) {
        if (bounds != null && bounds.length > 0 && (bounds.length != 1 || bounds[0] != Object.class)) {
            out.print(" extends ");
            int i = 0;
            for (Type bound : bounds) {
                if (i++ > 0) {
                    out.print("&");
                }
                GenericReflection.printType(bound);
            }
        }
    }

    public static void printParams(Type[] types) {
        if (types != null && types.length > 0) {
            out.print("<");
            int i = 0;
            for (Type type : types) {
                if (i++ > 0) {
                    out.print(",");
                }
                GenericReflection.printType(type);
            }
            out.print(">");
        }
    }

    public static void printType(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            out.print(c.getName());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            Class c = (Class)p.getRawType();
            Type o = p.getOwnerType();
            if (o != null) {
                GenericReflection.printType(o);
                out.print(".");
            }
            out.print(c.getName());
            GenericReflection.printParams(p.getActualTypeArguments());
        } else if (type instanceof TypeVariable) {
            TypeVariable v = (TypeVariable)type;
            out.print(v.getName());
        } else if (type instanceof GenericArrayType) {
            GenericArrayType a = (GenericArrayType)type;
            GenericReflection.printType(a.getGenericComponentType());
            out.print("[]");
        } else if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            Type[] upper = w.getUpperBounds();
            Type[] lower = w.getLowerBounds();
            if (upper.length == 1 && lower.length == 0) {
                out.print("? extends ");
                GenericReflection.printType(upper[0]);
            } else if (upper.length == 0 && lower.length == 1) {
                out.print("? super ");
                GenericReflection.printType(lower[0]);
            } else assert (false);
        }
    }

    public static void printClass(Class c) {
        out.print("class ");
        out.print(c.getName());
        GenericReflection.printTypeParameters(c.getTypeParameters());
        out.println();
        GenericReflection.printSuperclass(c.getGenericSuperclass());
        GenericReflection.printInterfaces(c.getGenericInterfaces());
    }

    public static void main(String[] args) throws ClassNotFoundException {
        for (String name : args) {
            Class<?> c = Class.forName(name);
            GenericReflection.printClass(c);
        }
    }
}

