/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.common3.Classes;
import org.scijava.common3.URLs;

public final class Apps {
    private static final Class<?> mainClass;

    private Apps() {
    }

    private static String mainClassName() {
        Map<Thread, StackTraceElement[]> traceMap = Thread.getAllStackTraces();
        for (Thread thread : traceMap.keySet()) {
            StackTraceElement[] trace;
            if (!"main".equals(thread.getName()) || (trace = traceMap.get(thread)) == null || trace.length == 0) continue;
            StackTraceElement element = trace[trace.length - 1];
            return element.getClassName();
        }
        return null;
    }

    public static Class<?> mainClass() {
        return mainClass;
    }

    public static File baseDirectory(String sysProp, Class<?> c, String baseSubdirectory) {
        File appPath;
        File dir;
        String property = System.getProperty(sysProp);
        if (property != null && (dir = new File(property)).isDirectory()) {
            return dir;
        }
        File basePath = Apps.baseDirectory(c, baseSubdirectory);
        if (basePath != null) {
            return basePath;
        }
        Class<?> mc = Apps.mainClass();
        File file = appPath = mc == null ? null : Apps.baseDirectory(mc);
        if (appPath != null) {
            return appPath;
        }
        return new File(".").getAbsoluteFile();
    }

    public static File baseDirectory(Class<?> c) {
        return Apps.baseDirectory(c, null);
    }

    public static File baseDirectory(Class<?> c, String baseSubdirectory) {
        File baseFile;
        URL location = Classes.location(c);
        try {
            baseFile = URLs.toFile(location);
        }
        catch (IllegalArgumentException exc) {
            baseFile = null;
        }
        return Apps.baseDirectory(baseFile, baseSubdirectory);
    }

    public static File baseDirectory(File classLocation, String baseSubdirectory) {
        String[] suffixes;
        if (classLocation == null) {
            return null;
        }
        String path = classLocation.getAbsolutePath().replace('\\', '/');
        if (path.contains("/.m2/repository/")) {
            return null;
        }
        Object basePrefix = "/";
        if (baseSubdirectory != null) {
            basePrefix = (String)basePrefix + baseSubdirectory + "/";
        }
        String targetClassesSuffix = (String)basePrefix + "target/classes";
        String targetTestClassesSuffix = (String)basePrefix + "target/test-classes";
        for (String suffix : suffixes = new String[]{targetClassesSuffix, targetTestClassesSuffix}) {
            if (!path.endsWith(suffix)) continue;
            path = path.substring(0, path.length() - suffix.length());
            File dir = new File(path);
            if (baseSubdirectory == null) {
                while (dir.getParentFile() != null && new File(dir.getParentFile(), "pom.xml").exists()) {
                    dir = dir.getParentFile();
                }
            }
            return dir;
        }
        Pattern pattern = Pattern.compile(".*(" + Pattern.quote((String)basePrefix + "target/") + "[^/]*\\.jar)");
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            int index = matcher.start(1);
            path = path.substring(0, index);
            return new File(path);
        }
        if (path.endsWith(".jar")) {
            File jarDirectory = classLocation.getParentFile();
            return jarDirectory.getParentFile();
        }
        return classLocation;
    }

    static {
        String className = Apps.mainClassName();
        mainClass = className == null ? null : Classes.load(className);
    }
}

