/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class Threads {
    private static final String NL = System.getProperty("line.separator");

    private Threads() {
    }

    public static String stackTrace(Throwable t) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream((OutputStream)out, false, "UTF-8"));
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException exc) {
            return null;
        }
    }

    public static String stackTrace(Thread thread) {
        StringBuilder sb = new StringBuilder();
        Threads.dumpThread(thread, thread.getStackTrace(), sb);
        return sb.toString();
    }

    public static String dumpAll() {
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ArrayList<Thread> threads = new ArrayList<Thread>(stackTraces.keySet());
        Collections.sort(threads, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        for (Thread t : threads) {
            Threads.dumpThread(t, stackTraces.get(t), sb);
        }
        return sb.toString();
    }

    private static void dumpThread(Thread t, StackTraceElement[] trace, StringBuilder sb) {
        Threads.threadInfo(t, sb);
        for (StackTraceElement element : trace) {
            sb.append("\tat ");
            sb.append(element);
            sb.append(NL);
        }
        sb.append(NL);
    }

    private static void threadInfo(Thread t, StringBuilder sb) {
        sb.append("\"");
        sb.append(t.getName());
        sb.append("\"");
        if (!t.isAlive()) {
            sb.append(" DEAD");
        }
        if (t.isInterrupted()) {
            sb.append(" INTERRUPTED");
        }
        if (t.isDaemon()) {
            sb.append(" daemon");
        }
        sb.append(" prio=");
        sb.append(t.getPriority());
        sb.append(" id=");
        sb.append(t.getId());
        sb.append(" group=");
        sb.append(t.getThreadGroup().getName());
        sb.append(NL);
        sb.append("   java.lang.Thread.State: ");
        sb.append((Object)t.getState());
        sb.append(NL);
    }
}

