/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.util.HashSet;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.scijava.maven.plugin.DependencyUtils;
import org.scijava.maven.plugin.SciJavaDependencyException;
import org.scijava.maven.plugin.SnapshotFinder;

public class RequireReproducibleBuilds
implements EnforcerRule {
    private final boolean failFast = false;
    private String groupId;
    private String groupIds;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            ArtifactRepository localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            MavenProjectBuilder projectBuilder = (MavenProjectBuilder)helper.getComponent(MavenProjectBuilder.class);
            DependencyTreeBuilder treeBuilder = (DependencyTreeBuilder)helper.getComponent(DependencyTreeBuilder.class);
            HashSet<String> ids = new HashSet<String>();
            if (this.groupId != null) {
                ids.add(this.groupId);
            }
            if (this.groupIds != null) {
                for (String id : this.groupIds.split(",")) {
                    ids.add(id);
                }
            }
            SnapshotFinder fs = new SnapshotFinder(projectBuilder, localRepository, project.getRemoteArtifactRepositories());
            fs.setLog(log);
            fs.setFailFast(false);
            fs.setGroupIds(ids);
            DependencyUtils.checkDependencies(project, localRepository, treeBuilder, fs);
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException(e.getMessage());
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getMessage());
        }
        catch (SciJavaDependencyException e) {
            throw new EnforcerRuleException(e.getMessage());
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getCacheId() {
        return null;
    }
}

