/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.scijava.maven.plugin.util.VersionVisitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PomEditor {
    private final Document doc;
    private final String projectTag;
    private final Log log;
    private XPath xpath;

    public PomEditor(InputStream inputStream, Log log) throws ParserConfigurationException, SAXException, IOException {
        this.log = log;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setCoalescing(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ProjectTagExtractor in = new ProjectTagExtractor(inputStream);
        this.doc = builder.parse(in);
        this.projectTag = in.toString();
    }

    public void write(Writer writer) throws DOMException, IOException {
        this.write(writer, this.doc.getDocumentElement());
        writer.write("\n");
        writer.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int visitVersions(VersionVisitor visitor) throws XPathExpressionException, MojoExecutionException {
        int modified = 0;
        String parentGroupId = this.cdata("//project/parent/groupId");
        if (parentGroupId != null) {
            String artifactId = this.cdata("//project/parent/artifactId");
            NodeList versions = this.xpath("//project/parent/version");
            if (versions == null || versions.getLength() != 1) {
                throw new MojoExecutionException("Could not find parent version");
            }
            if (this.visitVersion(parentGroupId, artifactId, versions.item(0), visitor)) {
                ++modified;
            }
        }
        NodeList properties = this.xpath("//project/properties/*");
        block4: for (int i = 0; i < properties.getLength(); ++i) {
            Node node = properties.item(i);
            switch (node.getNodeType()) {
                case 8: {
                    if (!node.getTextContent().contains("BEGIN MANUALLY MANAGED VERSIONS")) break;
                    break block4;
                }
                case 1: {
                    String propertyName = node.getNodeName();
                    if (propertyName == null || !propertyName.endsWith(".version")) break;
                    String artifactId = propertyName.substring(0, propertyName.length() - ".version".length());
                    if ("imagej1".equals(artifactId)) {
                        artifactId = "ij";
                    }
                    String search = "[artifactId[.='" + artifactId + "']]/groupId";
                    NodeList groupIdNodes = this.xpath("//project/dependencyManagement/dependencies/dependency" + search);
                    if (!(groupIdNodes != null && groupIdNodes.getLength() != 0 || (groupIdNodes = this.xpath("//project/dependencies/dependency" + search)) != null && groupIdNodes.getLength() != 0 || (groupIdNodes = this.xpath("//project/build/pluginManagement/plugins/plugin" + search)) != null && groupIdNodes.getLength() != 0)) {
                        groupIdNodes = this.xpath("//project/build/plugins/plugin" + search);
                    }
                    if (groupIdNodes == null || groupIdNodes.getLength() == 0) {
                        this.log.warn((CharSequence)("Could not determine groupId for artifactId '" + artifactId + "'; Skipping"));
                        break;
                    }
                    if (!this.visitVersion(groupIdNodes.item(0).getTextContent(), artifactId, node, visitor)) break;
                    ++modified;
                }
            }
        }
        NodeList importScopes = this.xpath("//project/dependencyManagement/dependencies/dependency[type[.='pom']][scope[.='import']]");
        int i = 0;
        while (i < importScopes.getLength()) {
            Node node = importScopes.item(i);
            String groupId = this.cdata("./groupId", node);
            String artifactId = this.cdata("./artifactId", node);
            NodeList versions = this.xpath("./version", node);
            if (versions == null || versions.getLength() != 1) {
                throw new MojoExecutionException("Could not find version for " + groupId + ":" + artifactId);
            }
            if (this.visitVersion(groupId, artifactId, versions.item(0), visitor)) {
                ++modified;
            }
            ++i;
        }
        return modified;
    }

    private boolean visitVersion(String groupId, String artifactId, Node node, VersionVisitor visitor) throws MojoExecutionException {
        String version = node.getTextContent();
        String newVersion = visitor.visit(groupId, artifactId, version);
        if (newVersion == null || version.equals(newVersion)) {
            return false;
        }
        this.log.info((CharSequence)(groupId + ":" + artifactId + ":" + version + " -> " + newVersion));
        node.setTextContent(newVersion);
        return true;
    }

    private String cdata(String expression) throws XPathExpressionException {
        return this.cdata(expression, this.doc);
    }

    private String cdata(String expression, Node node) throws XPathExpressionException {
        NodeList nodes = this.xpath(expression, node);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        NodeList children = nodes.item(0).getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    private NodeList xpath(String expression) throws XPathExpressionException {
        return this.xpath(expression, this.doc);
    }

    private NodeList xpath(String expression, Node node) throws XPathExpressionException {
        return (NodeList)this.xpath().evaluate(expression, node, XPathConstants.NODESET);
    }

    private synchronized XPath xpath() {
        if (this.xpath == null) {
            this.xpath = XPathFactory.newInstance().newXPath();
        }
        return this.xpath;
    }

    private void write(Writer writer, Node node) throws DOMException, IOException {
        if (node.getNodeType() == 3) {
            writer.write(node.getTextContent());
        } else if (node.getNodeType() == 8) {
            writer.write("<!--" + node.getTextContent() + "-->");
        } else if (node.hasChildNodes()) {
            String name = node.getNodeName();
            if ("project".equals(name)) {
                writer.write(this.projectTag);
            } else {
                writer.write("<" + name + ">");
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.write(writer, child);
            }
            writer.write("</" + name + ">");
        } else {
            writer.write("<" + node.getNodeName() + " />");
        }
    }

    private static class ProjectTagExtractor
    extends FilterInputStream {
        private static final byte[] magic = "<project".getBytes();
        private int counter;
        private final StringBuilder builder = new StringBuilder();

        private ProjectTagExtractor(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result > 0) {
                this.handle((byte)result);
            }
            return result;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            int result = super.read(buffer);
            for (int i = 0; i < result; ++i) {
                this.handle(buffer[i]);
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int result = super.read(buffer, offset, length);
            for (int i = 0; i < result; ++i) {
                this.handle(buffer[offset + i]);
            }
            return result;
        }

        public String toString() {
            return this.builder.toString();
        }

        private void handle(byte ch) {
            if (this.counter < 0) {
                return;
            }
            if (this.counter < magic.length) {
                this.counter = ch == magic[this.counter] ? ++this.counter : 0;
            } else if (ch == 62) {
                this.counter = -1;
            }
            this.builder.append((char)ch);
        }
    }
}

