/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RequireElements
implements EnforcerRule {
    private String[] elements;
    private Document doc;
    private XPath xpath;
    private final String ruleName = StringUtils.lowercaseFirstLetter((String)this.getClass().getSimpleName());

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        MavenProject project = this.getMavenProject(helper);
        if (this.elements == null || this.elements.length == 0) {
            this.fail("no elements were specified");
        }
        for (String element : this.elements) {
            if (!element.matches("[^A-Za-z0-9_/]")) continue;
            this.fail("invalid character in element name '" + element + "'");
        }
        File pomFile = project.getFile();
        if (pomFile == null) {
            this.fail("cannot locate project POM");
        }
        try {
            this.doc = RequireElements.loadXML(pomFile);
        }
        catch (ParserConfigurationException exc) {
            log.warn((CharSequence)"Cannot parse project POM", (Throwable)exc);
            return;
        }
        catch (SAXException exc) {
            log.warn((CharSequence)"Cannot parse project POM", (Throwable)exc);
            return;
        }
        catch (IOException exc) {
            log.warn((CharSequence)"Cannot parse project POM", (Throwable)exc);
            return;
        }
        this.xpath = XPathFactory.newInstance().newXPath();
        StringBuilder errors = new StringBuilder();
        for (String element : this.elements) {
            NodeList nodes = this.xpath("//project/" + element);
            if (nodes == null || nodes.getLength() <= 0) {
                errors.append("* " + element + ": element is missing\n");
                continue;
            }
            String text = nodes.item(0).getTextContent();
            if (text != null && !text.trim().isEmpty()) continue;
            errors.append("* " + element + ": element has no content\n");
        }
        if (errors.length() > 0) {
            throw new EnforcerRuleException("The following required elements have errors:\n" + errors);
        }
    }

    public String getCacheId() {
        return "0";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    private void fail(String message) throws EnforcerRuleException {
        throw new EnforcerRuleException(this.ruleName + ": " + message);
    }

    private MavenProject getMavenProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException exc) {
            throw new EnforcerRuleException("Unable to get project.", (Exception)((Object)exc));
        }
    }

    private NodeList xpath(String expression) throws EnforcerRuleException {
        Object o;
        try {
            o = this.xpath.evaluate(expression, this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exc) {
            throw new EnforcerRuleException("Cannot parse xpath expression", (Exception)exc);
        }
        if (!(o instanceof NodeList)) {
            String className = o == null ? "null" : o.getClass().getName();
            this.fail("Unexpected xpath result type: " + className);
        }
        return (NodeList)o;
    }

    private static Document loadXML(File file) throws ParserConfigurationException, SAXException, IOException {
        return RequireElements.createBuilder().parse(file.getAbsolutePath());
    }

    private static DocumentBuilder createBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }
}

