/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.FixtureLoader;
import fit.exception.ClassIsNotFixtureException;
import fit.exception.FixtureException;
import fit.exception.NoDefaultConstructorFixtureException;
import fit.exception.NoSuchFixtureException;
import fit.testFxtr.NoDefaultConstructorFixture;
import fit.testFxtr.WouldBeFixture;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class CannotLoadFixtureTest
extends TestCase {
    private FixtureLoader fixtureLoader;

    protected void setUp() throws Exception {
        this.fixtureLoader = new FixtureLoader();
    }

    public void testFixtureClassDoesNotExtendFixture() throws Throwable {
        this.assertCannotLoadFixture("Successfully loaded a fixture that does not extend Fixture!", WouldBeFixture.class.getName(), ClassIsNotFixtureException.class);
    }

    public void testFixtureClassNotEndingInFixtureDoesNotExtendFixture() throws Throwable {
        this.assertCannotLoadFixtureAfterChoppingOffFixture("Successfully loaded a fixture that does not extend Fixture!", WouldBeFixture.class, ClassIsNotFixtureException.class);
    }

    public void testFixtureHasNoDefaultConstructor() throws Throwable {
        this.assertCannotLoadFixture("Successfully loaded a fixture with no default constructor!", NoDefaultConstructorFixture.class.getName(), NoDefaultConstructorFixtureException.class);
    }

    public void testFixtureClassNotEndingInFixtureHasNoDefaultConstructor() throws Throwable {
        this.assertCannotLoadFixtureAfterChoppingOffFixture("Successfully loaded a fixture with no default constructor!", NoDefaultConstructorFixture.class, NoDefaultConstructorFixtureException.class);
    }

    public void testFixtureNameNotFound() throws Throwable {
        this.assertCannotLoadFixture("Successfully loaded a nonexistent fixture!", "BlahBlahBlah", NoSuchFixtureException.class);
    }

    public void testFixtureNameNotFoundEvenAfterAddingOnFixture() throws Throwable {
        try {
            this.fixtureLoader.disgraceThenLoad("BlahBlahBlah");
            CannotLoadFixtureTest.fail((String)"Successfully loaded a nonexistent fixture!");
        }
        catch (FixtureException expected) {
            CannotLoadFixtureTest.assertEquals(NoSuchFixtureException.class, ((Object)((Object)expected)).getClass());
            CannotLoadFixtureTest.assertEquals((String)"BlahBlahBlah", (String)expected.fixtureName);
        }
    }

    private String chopOffFixture(Class<?> fixtureClass) {
        return fixtureClass.getName().replaceAll("Fixture", "");
    }

    private void assertCannotLoadFixture(String failureMessage, String fixtureName, Class<?> expectedExceptionType) throws Throwable {
        try {
            this.fixtureLoader.disgraceThenLoad(fixtureName);
            CannotLoadFixtureTest.fail((String)failureMessage);
        }
        catch (FixtureException expected) {
            CannotLoadFixtureTest.assertEquals(expectedExceptionType, ((Object)((Object)expected)).getClass());
            CannotLoadFixtureTest.assertEquals((String)fixtureName, (String)expected.fixtureName);
        }
    }

    private void assertCannotLoadFixtureAfterChoppingOffFixture(String failureMessage, Class<?> fixtureClass, Class<?> expectedExceptionType) throws Throwable {
        try {
            this.fixtureLoader.disgraceThenLoad(this.chopOffFixture(fixtureClass));
            CannotLoadFixtureTest.fail((String)failureMessage);
        }
        catch (FixtureException expected) {
            CannotLoadFixtureTest.assertEquals((String)("Got exception: " + (Object)((Object)expected)), expectedExceptionType, ((Object)((Object)expected)).getClass());
            CannotLoadFixtureTest.assertEquals((String)fixtureClass.getName(), (String)expected.fixtureName);
        }
    }
}

