/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator;

import fit.Fixture;
import fit.Parse;
import fit.decorator.FixtureDecorator;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.Delta;
import fit.decorator.util.Table;

public class IncrementColumnsValue
extends FixtureDecorator {
    public static final String COLUMN_NAME = "columnName";
    public static final String DELTA = "delta";
    private String columnName;
    private Delta delta;

    protected void setupDecorator(String[] arguments) throws InvalidInputException {
        if (arguments.length != 3) {
            throw new InvalidInputException("Column name, Data type and Delta Value must be specified");
        }
        this.columnName = arguments[0];
        this.delta = new Delta(arguments[1], arguments[2]);
        this.summary.put(COLUMN_NAME, this.columnName);
        this.summary.put(DELTA, this.delta);
    }

    protected void run(Fixture fixture, Parse table) {
        Table t = new Table(table);
        try {
            table = t.incrementColumnValuesByDelta(this.columnName, this.delta);
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        super.run(fixture, table);
    }

    protected void updateColumnsBasedOnResults(Parse table) {
    }
}

