/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fit.Fixture;
import fit.Parse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class FitFilter {
    public String input;
    public Parse tables;
    public Fixture fixture = new Fixture();
    public PrintWriter output;

    public static void main(String[] argv) {
        new FitFilter().run(argv);
    }

    public void run(String[] argv) {
        this.args(argv);
        this.process();
        this.exit();
    }

    public void process() {
        try {
            this.tables = new Parse(this.input);
            this.fixture.doTables(this.tables);
        }
        catch (Exception e) {
            this.exception(e);
        }
        this.tables.print(this.output);
    }

    public void args(String[] argv) {
        if (argv.length != 0) {
            System.err.println("usage: java fitnesse.FitFilter");
            System.exit(-1);
        }
        try {
            this.input = this.read();
            this.output = new PrintWriter(System.out);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    protected String read() throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while ((line = br.readLine()) != null) {
            buffer.append(line).append("\n");
        }
        return buffer.toString();
    }

    protected void exception(Exception e) {
        this.tables = new Parse("body", "Unable to parse input. Input ignored.", null, null);
        this.fixture.exception(this.tables, (Throwable)e);
    }

    protected void exit() {
        this.output.close();
        System.exit(this.fixture.counts.wrong + this.fixture.counts.exceptions);
    }
}

