/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseVersion;
import org.junit.Assert;
import org.junit.Test;

public class FitNesseVersionTest {
    @Test
    public void doesLoadVersionResourceFile() {
        FitNesseVersion version = new FitNesseVersion();
        Assert.assertTrue((boolean)version.toString().startsWith("v"));
        Assert.assertFalse((boolean)version.toString().endsWith("\n"));
    }

    @Test
    public void earlierVersionDateShouldNotBeAtLeastVersion() throws Exception {
        FitNesseVersion version = new FitNesseVersion("v20100101");
        Assert.assertFalse((boolean)version.isAtLeast("v20100303"));
    }

    @Test
    public void exactVersionDateShouldBeAtLeastVersion() throws Exception {
        FitNesseVersion version = new FitNesseVersion("v20100303");
        Assert.assertTrue((boolean)version.isAtLeast("v20100303"));
    }

    @Test
    public void laterVersionDateShouldBeAtLeastVersion() throws Exception {
        FitNesseVersion version = new FitNesseVersion("v20100613");
        Assert.assertTrue((boolean)version.isAtLeast("v20100303"));
    }

    @Test
    public void veryOldImaginaryVersionDoesntCauseRuntimeException() throws Exception {
        FitNesseVersion version = new FitNesseVersion("v20100613");
        Assert.assertTrue((boolean)version.isAtLeast("v100303"));
    }

    @Test
    public void dateVersionsHandlesVersionsWithExtraSuffixes() throws Exception {
        Assert.assertEquals((Object)20100101L, (Object)FitNesseVersion.dateVersion((String)"v20100101-abc-1"));
    }

    @Test
    public void dateVersionsHandlesVersionsWithNoExtraSuffixes() throws Exception {
        Assert.assertEquals((Object)20100101L, (Object)FitNesseVersion.dateVersion((String)"v20100101"));
    }

    @Test
    public void versionsWithSuffixesCompareToVersionsWithoutSuffix() throws Exception {
        FitNesseVersion version = new FitNesseVersion("v20100101-abc-1");
        Assert.assertFalse((boolean)version.isAtLeast("v20100303"));
    }

    @Test
    public void suffixesAreIgnoredWhenComparingVersions() throws Exception {
        FitNesseVersion version = new FitNesseVersion("v20100101-abc-1");
        Assert.assertFalse((boolean)version.isAtLeast("v20100303-abc-2"));
    }
}

