/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.TransparentCipher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import util.FileUtil;

public class PasswordFile {
    private File passwordFile;
    private Map<String, String> passwordMap = new HashMap();
    private PasswordCipher cipher = new TransparentCipher();

    public PasswordFile(String filename) throws IOException {
        this.passwordFile = new File(filename);
        this.loadFile();
    }

    public PasswordFile(String filename, PasswordCipher cipher) throws IOException {
        this(filename);
        this.cipher = cipher;
    }

    public Map<String, String> getPasswordMap() {
        return this.passwordMap;
    }

    public String getName() {
        return this.passwordFile.getName();
    }

    public PasswordCipher getCipher() {
        return this.cipher;
    }

    public void savePassword(String user, String password) throws FileNotFoundException {
        this.passwordMap.put(user, this.cipher.encrypt(password));
        this.savePasswords();
    }

    private void loadFile() throws IOException {
        LinkedList lines = this.getPasswordFileLines();
        this.loadCipher(lines);
        this.loadPasswords(lines);
    }

    private void loadPasswords(LinkedList<String> lines) {
        for (String line : lines) {
            if ("".equals(line)) continue;
            String[] tokens = line.split(":");
            this.passwordMap.put(tokens[0], tokens[1]);
        }
    }

    private void loadCipher(LinkedList<String> lines) {
        String firstLine;
        if (lines.size() > 0 && (firstLine = lines.getFirst().toString()).startsWith("!")) {
            String cipherClassName = firstLine.substring(1);
            try {
                this.instantiateCipher(cipherClassName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            lines.removeFirst();
        }
    }

    public PasswordCipher instantiateCipher(String cipherClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.cipher = (PasswordCipher)Class.forName(cipherClassName).newInstance();
        return this.cipher;
    }

    private void savePasswords() throws FileNotFoundException {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("!" + this.cipher.getClass().getName());
        for (Object user : this.passwordMap.keySet()) {
            Object password = this.passwordMap.get(user);
            lines.add(user + ":" + password);
        }
        FileUtil.writeLinesToFile((File)this.passwordFile, lines);
    }

    private LinkedList<String> getPasswordFileLines() throws IOException {
        LinkedList lines = new LinkedList();
        if (this.passwordFile.exists()) {
            lines = FileUtil.getFileLines((File)this.passwordFile);
        }
        return lines;
    }
}

