/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.HashingCipher;
import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.PasswordFile;
import fitnesse.authentication.TransparentCipher;
import java.io.File;
import util.FileUtil;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class PasswordFileTest
extends RegexTestCase {
    private PasswordFile passwords;
    private File passwordFile;
    private PasswordCipher cipher = new HashingCipher();
    private String passwordFilename = "testDir/password.txt";

    public void setUp() throws Exception {
        new File("testDir").mkdir();
        this.passwords = new PasswordFile(this.passwordFilename, this.cipher);
        this.passwordFile = new File(this.passwordFilename);
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)"testDir");
    }

    public void testSavePasswordForFirstUser() throws Exception {
        this.passwords.savePassword("Aladdin", "open sesame");
        PasswordFileTest.assertTrue((boolean)this.passwordFile.exists());
        String contents = FileUtil.getFileContent((File)this.passwordFile);
        PasswordFileTest.assertSubString((String)("Aladdin:" + this.cipher.encrypt("open sesame")), (String)contents);
    }

    public void testChangePasswordForFirstUser() throws Exception {
        this.passwords.savePassword("Aladdin", "open sesame");
        this.passwords.savePassword("Aladdin", "open please");
        String contents = FileUtil.getFileContent((File)this.passwordFile);
        PasswordFileTest.assertNotSubString((String)("Aladdin:" + this.cipher.encrypt("open sesame")), (String)contents);
        PasswordFileTest.assertSubString((String)("Aladdin:" + this.cipher.encrypt("open please")), (String)contents);
    }

    public void testMultipleUsers() throws Exception {
        this.addTMNTUsers();
        String contents = FileUtil.getFileContent((File)this.passwordFile);
        PasswordFileTest.assertSubString((String)("Leonardo:" + this.cipher.encrypt("katana")), (String)contents);
        PasswordFileTest.assertSubString((String)("Donatello:" + this.cipher.encrypt("bo")), (String)contents);
        PasswordFileTest.assertSubString((String)("Michaelangelo:" + this.cipher.encrypt("nunchaku")), (String)contents);
        PasswordFileTest.assertSubString((String)("Rafael:" + this.cipher.encrypt("sai")), (String)contents);
    }

    public void testAddChangePasswordWithMultipleUsers() throws Exception {
        this.addTMNTUsers();
        this.passwords.savePassword("Donatello", "manrikigusari");
        String contents = FileUtil.getFileContent((File)this.passwordFile);
        PasswordFileTest.assertSubString((String)("Leonardo:" + this.cipher.encrypt("katana")), (String)contents);
        PasswordFileTest.assertSubString((String)("Donatello:" + this.cipher.encrypt("manrikigusari")), (String)contents);
        PasswordFileTest.assertSubString((String)("Michaelangelo:" + this.cipher.encrypt("nunchaku")), (String)contents);
        PasswordFileTest.assertSubString((String)("Rafael:" + this.cipher.encrypt("sai")), (String)contents);
    }

    private void addTMNTUsers() throws Exception {
        this.passwords.savePassword("Leonardo", "katana");
        this.passwords.savePassword("Donatello", "bo");
        this.passwords.savePassword("Michaelangelo", "nunchaku");
        this.passwords.savePassword("Rafael", "sai");
    }

    public void testWritesAndReadsCipherType1() throws Exception {
        this.passwords.savePassword("rocksteady", "horn");
        String contents = FileUtil.getFileContent((File)this.passwordFile);
        PasswordFileTest.assertSubString((String)"!fitnesse.authentication.HashingCipher", (String)contents);
        this.passwords = new PasswordFile(this.passwordFilename);
        PasswordFileTest.assertEquals(HashingCipher.class, this.passwords.getCipher().getClass());
    }

    public void testWritesAndReadsCipherType2() throws Exception {
        this.passwordFilename = "testDir/passwords2.txt";
        this.setUp();
        this.passwords = new PasswordFile(this.passwordFilename);
        this.passwords.savePassword("rocksteady", "horn");
        String contents = FileUtil.getFileContent((File)this.passwordFile);
        PasswordFileTest.assertSubString((String)"!fitnesse.authentication.TransparentCipher", (String)contents);
        this.passwords = new PasswordFile(this.passwordFilename);
        PasswordFileTest.assertEquals(TransparentCipher.class, this.passwords.getCipher().getClass());
    }
}

