/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.ContentBuffer;
import java.io.File;
import java.io.InputStream;
import junit.framework.TestCase;
import util.StreamReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContentBufferTest
extends TestCase {
    public void testName() throws Exception {
        String name = new ContentBuffer().getFile().getName();
        ContentBufferTest.assertTrue((boolean)name.startsWith("FitNesse-"));
        ContentBufferTest.assertTrue((boolean)name.endsWith(".tmp"));
        name = new ContentBuffer(".html").getFile().getName();
        ContentBufferTest.assertTrue((boolean)name.startsWith("FitNesse-"));
        ContentBufferTest.assertTrue((boolean)name.endsWith(".html"));
    }

    public void testSimpleUsage() throws Exception {
        ContentBuffer buffer = new ContentBuffer();
        buffer.append("some content");
        ContentBufferTest.assertEquals((String)"some content", (String)buffer.getContent());
    }

    public void testGettingInputStream() throws Exception {
        ContentBuffer buffer = new ContentBuffer();
        buffer.append("some content");
        int bytes = buffer.getSize();
        ContentBufferTest.assertEquals((int)12, (int)bytes);
        InputStream input = buffer.getInputStream();
        String content = new StreamReader(input).read(12);
        ContentBufferTest.assertEquals((String)"some content", (String)content);
    }

    public void testDelete() throws Exception {
        ContentBuffer buffer = new ContentBuffer();
        File file = buffer.getFile();
        ContentBufferTest.assertTrue((boolean)file.exists());
        buffer.delete();
        ContentBufferTest.assertFalse((boolean)file.exists());
    }

    public void testUnicode() throws Exception {
        ContentBuffer buffer = new ContentBuffer();
        buffer.append("??\ufffd\ufffd");
        ContentBufferTest.assertEquals((String)"??\ufffd\ufffd", (String)new StreamReader(buffer.getInputStream()).read(buffer.getSize()));
    }
}

