/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.PageReferenceRenamer;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageReferenceRenamerTest
extends RegexTestCase {
    WikiPage root;
    WikiPage subWiki;
    WikiPage subWiki_pageOne;
    WikiPage subWiki_pageTwo;
    WikiPage subWiki_pageTwo_pageTwoChild;
    PageReferenceRenamer renamer;
    private PageCrawler crawler;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.subWiki = this.crawler.addPage(this.root, PathParser.parse((String)"SubWiki"), "");
        this.subWiki_pageTwo = this.crawler.addPage(this.subWiki, PathParser.parse((String)"PageTwo"), "");
        this.subWiki_pageTwo_pageTwoChild = this.crawler.addPage(this.subWiki_pageTwo, PathParser.parse((String)"PageTwoChild"), "");
    }

    public void testReferencesOnPageOne_1() throws Exception {
        this.checkChangesOnPageOne("Stuff PageTwo Stuff\n", "Stuff PageThree Stuff\n");
    }

    public void testReferencesOnPageOne_2() throws Exception {
        this.checkChangesOnPageOne("Stuff !-PageTwo-! Stuff\n", "Stuff !-PageTwo-! Stuff\n");
    }

    public void testReferencesOnPageOne_3() throws Exception {
        this.checkChangesOnPageOne("Stuff PageOne.PageTwo Stuff\n", "Stuff PageOne.PageTwo Stuff\n");
    }

    public void testReferencesOnPageOne_4() throws Exception {
        this.checkChangesOnPageOne("Stuff .SubWiki.PageTwo.PageTwoChild Stuff\n", "Stuff .SubWiki.PageThree.PageTwoChild Stuff\n");
    }

    public void testReferencesOnPageOne_5() throws Exception {
        this.checkChangesOnPageOne("Stuff ^PageTwo Stuff\n", "Stuff ^PageTwo Stuff\n");
    }

    public void testReferencesOnPageOne_6() throws Exception {
        this.checkChangesOnPageOne("# Stuff PageTwo Stuff\n", "# Stuff PageTwo Stuff\n");
    }

    public void testReferencesOnPageOne_7() throws Exception {
        this.checkChangesOnPageOne("{{{Stuff PageTwo Stuff}}}\n", "{{{Stuff PageTwo Stuff}}}\n");
    }

    public void testReferencesOnPageOne_8() throws Exception {
        this.checkChangesOnPageOne("Stuff .SubWiki.PageTwo Stuff\n", "Stuff .SubWiki.PageThree Stuff\n");
    }

    public void testReferencesOnPageOne_9() throws Exception {
        this.checkChangesOnPageOne("Stuff .SubWiki.PageTwo.NoPage Stuff\n", "Stuff .SubWiki.PageThree.NoPage Stuff\n");
    }

    public void testTestReferencesToSubWiki_1() throws Exception {
        PageData data = this.subWiki.getData();
        data.setContent("Stuff >PageTwo Stuff\n");
        this.subWiki.commit(data);
        this.renamer = new PageReferenceRenamer(this.root, this.subWiki_pageTwo, "PageThree");
        this.renamer.renameReferences();
        String updatedSubWikiContent = this.subWiki.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)"Stuff >PageThree Stuff\n", (String)updatedSubWikiContent);
    }

    public void testTestReferencesToSubWiki_2() throws Exception {
        PageData data = this.subWiki.getData();
        data.setContent("Stuff >PageTwo.DeepPage Stuff\n");
        this.subWiki.commit(data);
        this.renamer = new PageReferenceRenamer(this.root, this.subWiki_pageTwo, "PageThree");
        this.renamer.renameReferences();
        String updatedSubWikiContent = this.subWiki.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)"Stuff >PageThree.DeepPage Stuff\n", (String)updatedSubWikiContent);
    }

    private void checkChangesOnPageOne(String beforeText, String expectedAfterText) throws Exception {
        this.subWiki_pageOne = this.crawler.addPage(this.subWiki, PathParser.parse((String)"PageOne"), beforeText);
        this.renamer = new PageReferenceRenamer(this.root, this.subWiki_pageTwo, "PageThree");
        this.renamer.renameReferences();
        this.subWiki_pageOne = this.subWiki.getChildPage("PageOne");
        String updatedPageOneContent = this.subWiki_pageOne.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)expectedAfterText, (String)updatedPageOneContent);
    }

    public void testRenameParentPage() throws Exception {
        PageData pageTwoChildData = this.subWiki_pageTwo_pageTwoChild.getData();
        pageTwoChildData.setContent("gunk .SubWiki.PageTwo gunk");
        this.subWiki_pageTwo_pageTwoChild.commit(pageTwoChildData);
        this.renamer = new PageReferenceRenamer(this.root, this.subWiki_pageTwo, "PageThree");
        this.renamer.renameReferences();
        String updatedContent = this.subWiki_pageTwo_pageTwoChild.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)"gunk .SubWiki.PageThree gunk", (String)updatedContent);
    }

    public void testSubPageReferenceUnchangedWhenParentRenamed() throws Exception {
        WikiPage pageOne = this.crawler.addPage(this.subWiki, PathParser.parse((String)"PageOne"), "gunk ^SubPage gunk");
        this.renamer = new PageReferenceRenamer(this.root, this.subWiki, "RenamedSubWiki");
        this.renamer.renameReferences();
        String updatedContent = pageOne.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)"gunk ^SubPage gunk", (String)updatedContent);
    }

    public void testRenameParentWithSubPageReferenceOnSibling() throws Exception {
        WikiPage pageOne = this.crawler.addPage(this.subWiki, PathParser.parse((String)"PageOne"), "gunk PageTwo gunk");
        this.renamer = new PageReferenceRenamer(this.root, this.subWiki, "RenamedSubWiki");
        this.renamer.renameReferences();
        String updatedContent = pageOne.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)"gunk PageTwo gunk", (String)updatedContent);
    }

    public void testRenameSiblingOfRoot() throws Exception {
        WikiPage source = this.crawler.addPage(this.root, PathParser.parse((String)"SourcePage"), "gunk TargetPage gunk");
        WikiPage target = this.crawler.addPage(this.root, PathParser.parse((String)"TargetPage"));
        this.renamer = new PageReferenceRenamer(this.root, target, "RenamedPage");
        this.renamer.renameReferences();
        String updatedSourceContent = source.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)"gunk RenamedPage gunk", (String)updatedSourceContent);
    }

    public void testRenameSubpageOfRoot() throws Exception {
        WikiPage source = this.crawler.addPage(this.root, PathParser.parse((String)"SourcePage"), "gunk ^TargetPage gunk");
        WikiPage target = this.crawler.addPage(source, PathParser.parse((String)"TargetPage"));
        this.renamer = new PageReferenceRenamer(this.root, target, "RenamedPage");
        this.renamer.renameReferences();
        String updatedSourceContent = source.getData().getContent();
        PageReferenceRenamerTest.assertEquals((String)"gunk >RenamedPage gunk", (String)updatedSourceContent);
    }

    public void testImageNotChanged() throws Exception {
        String IMAGE_WIDGET = "!img http://PageTwo.jpg";
        this.checkChangesOnPageOne("!img http://PageTwo.jpg", "!img http://PageTwo.jpg");
    }

    public void testLinkNotChanged() throws Exception {
        String LINK_WIDGET = "http://PageTwo";
        this.checkChangesOnPageOne("http://PageTwo", "http://PageTwo");
    }

    public void testPathNotChanged() throws Exception {
        String PATH_WIDGET = "!path PageTwo";
        this.checkChangesOnPageOne("!path PageTwo", "!path PageTwo");
    }

    public void testAliasTagNotChanged() throws Exception {
        String ALIAS_LINK = "[[PageTwo][MyPageTwo]]";
        this.checkChangesOnPageOne("[[PageTwo][MyPageTwo]]", "[[PageTwo][MyPageTwo]]");
    }

    public void testAliasLinkRenamed() throws Exception {
        this.checkChangesOnPageOne("gunk [[gunk][PageTwo]] gunk", "gunk [[gunk][PageThree]] gunk");
    }

    public void testAliasLinWithLiteralDoesntGetCorrupted() throws Exception {
        this.checkChangesOnPageOne("gunk [[!-gunk-!][PageTwo]] gunk", "gunk [[!-gunk-!][PageThree]] gunk");
    }

    public void testXrefWidgetRenamed() throws Exception {
        this.checkChangesOnPageOne("!see PageTwo", "!see PageThree");
    }
}

