/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.SuiteSpecificationMatchFinder;
import fitnesse.components.TraversalListener;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SuiteSpecificationMatchFinderTest
implements TraversalListener<WikiPage> {
    WikiPage root;
    private List<WikiPage> hits = new ArrayList();
    private PageCrawler crawler;
    SuiteSpecificationMatchFinder finder;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPageOne"), "TestPageOne has some testing content and a child\nThe meaning of life, the universe, and evertything is 42");
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPageOne.ChildPage"), "ChildPage is a child of TestPageOne\nDo you believe in love after life?");
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPageTwo"), "TestPageTwo has a bit of content too\nThere is no life without death");
        this.hits.clear();
    }

    @Test
    public void shouldBeAbleToFindAPageFromItsTitle() throws Exception {
        this.finder = new SuiteSpecificationMatchFinder("Test", "", (TraversalListener)this);
        this.finder.search(this.root);
        this.assertPagesFound(new String[]{"TestPageOne", "TestPageTwo"});
    }

    @Test
    public void shouldBeAbleToFindAPageFromItsContent() throws Exception {
        this.finder = new SuiteSpecificationMatchFinder("", "content", (TraversalListener)this);
        this.finder.search(this.root);
        this.assertPagesFound(new String[]{"TestPageOne", "TestPageTwo"});
    }

    @Test
    public void shouldHandleNullTitle() throws Exception {
        this.finder = new SuiteSpecificationMatchFinder(null, "child", (TraversalListener)this);
        this.finder.search(this.root);
        this.assertPagesFound(new String[]{"TestPageOne", "ChildPage"});
    }

    @Test
    public void shouldHandleNullContent() throws Exception {
        this.finder = new SuiteSpecificationMatchFinder("Child", null, (TraversalListener)this);
        this.finder.search(this.root);
        this.assertPagesFound(new String[]{"ChildPage"});
    }

    @Test
    public void shouldBeAbleToUseRegExForContent() throws Exception {
        this.finder = new SuiteSpecificationMatchFinder(null, "has.*content", (TraversalListener)this);
        this.finder.search(this.root);
        this.assertPagesFound(new String[]{"TestPageOne", "TestPageTwo"});
    }

    @Test
    public void shouldBeAbleToFindContentOverManyLines() throws Exception {
        this.finder = new SuiteSpecificationMatchFinder(null, "child.*life", (TraversalListener)this);
        this.finder.search(this.root);
        this.assertPagesFound(new String[]{"TestPageOne", "ChildPage"});
    }

    public void process(WikiPage page) {
        this.hits.add(page);
    }

    private void assertPagesFound(String ... pageNames) throws Exception {
        Assert.assertEquals((long)pageNames.length, (long)this.hits.size());
        List<String> pageNameList = Arrays.asList(pageNames);
        for (WikiPage page : this.hits) {
            Assert.assertTrue((boolean)pageNameList.contains(page.getName()));
        }
    }
}

