/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.TitleWikiPageFinder;
import fitnesse.components.TraversalListener;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TitleWikiPageFinderTest
implements TraversalListener<WikiPage> {
    WikiPage root;
    private WikiPage pageTwo;
    private List<WikiPage> hits = new ArrayList();
    private PageCrawler crawler;
    private TitleWikiPageFinder searcher;

    public void process(WikiPage page) {
        this.hits.add(page);
    }

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"), "has PageOne content");
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.PageOneChild"), "PageChild is a child of PageOne");
        this.pageTwo = this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"), "PageTwo has a bit of content too\n^PageOneChild");
        PageData data = this.pageTwo.getData();
        this.pageTwo.commit(data);
        this.hits.clear();
    }

    @Test
    public void titleSearch() throws Exception {
        this.searcher = new TitleWikiPageFinder("one", (TraversalListener)this);
        this.hits.clear();
        this.searcher.search(this.root);
        this.assertPagesFound(new String[]{"PageOne", "PageOneChild"});
    }

    private void assertPagesFound(String ... pageNames) throws Exception {
        Assert.assertEquals((long)pageNames.length, (long)this.hits.size());
        List<String> pageNameList = Arrays.asList(pageNames);
        for (WikiPage page : this.hits) {
            Assert.assertTrue((boolean)pageNameList.contains(page.getName()));
        }
    }
}

