/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.PageFinder;
import fitnesse.components.TraversalListener;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.parser.WikiWord;
import java.util.ArrayList;
import java.util.List;

public class WhereUsedPageFinder
implements TraversalListener<WikiPage>,
PageFinder,
SymbolTreeWalker {
    private WikiPage subjectPage;
    private TraversalListener<? super WikiPage> observer;
    private WikiPage currentPage;
    private List<WikiPage> hits = new ArrayList();

    public WhereUsedPageFinder(WikiPage subjectPage, TraversalListener<? super WikiPage> observer) {
        this.subjectPage = subjectPage;
        this.observer = observer;
    }

    public void hit(WikiPage referencingPage) {
    }

    public void process(WikiPage currentPage) {
        this.currentPage = currentPage;
        String content = currentPage.getData().getContent();
        Symbol syntaxTree = Parser.make((ParsingPage)new ParsingPage((SourcePage)new WikiSourcePage(currentPage)), (String)content, (SymbolProvider)SymbolProvider.refactoringProvider).parse();
        syntaxTree.walkPreOrder((SymbolTreeWalker)this);
    }

    public List<WikiPage> search(WikiPage page) {
        this.hits.clear();
        this.subjectPage.getPageCrawler().traverse(page, (TraversalListener)this);
        return this.hits;
    }

    public boolean visit(Symbol node) {
        if (!node.isType((SymbolType)WikiWord.symbolType)) {
            return true;
        }
        if (this.hits.contains(this.currentPage)) {
            return true;
        }
        try {
            WikiPage referencedPage = new WikiWordReference(this.currentPage, node.getContent()).getReferencedPage();
            if (referencedPage != null && referencedPage.equals(this.subjectPage)) {
                this.hits.add(this.currentPage);
                this.observer.process((Object)this.currentPage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean visitChildren(Symbol node) {
        return true;
    }
}

