/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageActions;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlUtilTest
extends RegexTestCase {
    private WikiPage root;
    private FitNesseContext context;

    public void setUp() {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    public void testMakeDivTag() {
        String expected = "<div class=\"myClass\"></div>" + HtmlElement.endl;
        HtmlUtilTest.assertEquals((String)expected, (String)HtmlUtil.makeDivTag((String)"myClass").html());
    }

    public void testMakeDefaultActions() {
        String pageName = "SomePage";
        String html = this.getActionsHtml(pageName);
        this.verifyDefaultLinks(html, "SomePage");
    }

    public void testMakeActionsWithTestButtonWhenNameStartsWithTest() {
        String pageName = "TestSomething";
        String html = this.getActionsHtml(pageName);
        this.verifyDefaultLinks(html, pageName);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?test\" accesskey=\"t\">Test</a>"), (String)html);
    }

    public void testMakeActionsWithSuffixButtonWhenNameEndsWithTest() {
        String pageName = "SomethingTest";
        String html = this.getActionsHtml(pageName);
        this.verifyDefaultLinks(html, pageName);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?test\" accesskey=\"t\">Test</a>"), (String)html);
    }

    public void testMakeActionsWithSuiteButtonWhenNameStartsWithSuite() {
        String pageName = "SuiteNothings";
        String html = this.getActionsHtml(pageName);
        this.verifyDefaultLinks(html, pageName);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?suite\" accesskey=\"\">Suite</a>"), (String)html);
    }

    public void testMakeActionsWithSuiteButtonWhenNameEndsWithSuite() {
        String pageName = "NothingsSuite";
        String html = this.getActionsHtml(pageName);
        this.verifyDefaultLinks(html, pageName);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?suite\" accesskey=\"\">Suite</a>"), (String)html);
    }

    private String getActionsHtml(String pageName) {
        this.root.addChildPage(pageName);
        HtmlPage htmlPage = this.context.pageFactory.newPage();
        htmlPage.setNavTemplate("wikiNav.vm");
        htmlPage.put("actions", (Object)new WikiPageActions(this.root.getChildPage(pageName)));
        return htmlPage.html();
    }

    private void verifyDefaultLinks(String html, String pageName) {
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?edit\" accesskey=\"e\">Edit</a>"), (String)html);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?versions\" accesskey=\"v\">Versions</a>"), (String)html);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?properties\" accesskey=\"p\">Properties</a>"), (String)html);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?refactor&amp;type=rename\">Rename</a>"), (String)html);
        HtmlUtilTest.assertSubString((String)("<a href=\"" + pageName + "?whereUsed\" accesskey=\"w\">Where Used</a>"), (String)html);
        HtmlUtilTest.assertSubString((String)"<a href=\"/files\" accesskey=\"f\">Files</a>", (String)html);
        HtmlUtilTest.assertSubString((String)"<a href=\"?searchForm\" accesskey=\"s\">Search</a>", (String)html);
        HtmlUtilTest.assertSubString((String)"<a href=\".FitNesse.UserGuide\" accesskey=\"\">User Guide</a>", (String)html);
    }

    public void testMakeReplaceElementScript() {
        String newText = "<p>My string has \"quotes\" and \r \n</p>";
        HtmlTag scriptTag = HtmlUtil.makeReplaceElementScript((String)"element-name", (String)newText);
        String expected = "<script>document.getElementById(\"element-name\").innerHTML = \"<p>My string has \\\"quotes\\\" and \\r \\n</p>\";</script>";
        HtmlUtilTest.assertSubString((String)expected, (String)scriptTag.html());
    }

    public void testMakeToggleClassScript() {
        HtmlTag scriptTag = HtmlUtil.makeToggleClassScript((String)"some-id", (String)"some-class");
        String expected = "<script>$(\"#some-id\").toggleClass(\"some-class\");</script>";
        HtmlUtilTest.assertSubString((String)expected, (String)scriptTag.html());
    }

    public void testMakeInitErrorMetadataScript() {
        HtmlTag scriptTag = HtmlUtil.makeInitErrorMetadataScript();
        String expected = "<script>initErrorMetadata();</script>";
        HtmlUtilTest.assertSubString((String)expected, (String)scriptTag.html());
    }

    public void testMakeAppendElementScript() {
        String appendText = "<p>My string has \"quotes\" and \r \n</p>";
        HtmlTag scriptTag = HtmlUtil.makeAppendElementScript((String)"element-name", (String)appendText);
        String expected1 = "<script>var existingContent = document.getElementById(\"element-name\").innerHTML;";
        String expected2 = "document.getElementById(\"element-name\").innerHTML = existingContent + \"<p>My string has \\\"quotes\\\" and \\r \\n</p>\";";
        String expected3 = "</script>";
        HtmlUtilTest.assertSubString((String)expected1, (String)scriptTag.html());
        HtmlUtilTest.assertSubString((String)expected2, (String)scriptTag.html());
        HtmlUtilTest.assertSubString((String)expected3, (String)scriptTag.html());
    }

    public void testMakeSilentLink() {
        HtmlTag tag = HtmlUtil.makeSilentLink((String)"test?responder", (HtmlElement)new RawHtml("string with \"quotes\""));
        HtmlUtilTest.assertSubString((String)"<a href=\"#\" onclick=\"doSilentRequest('test?responder')\">string with \"quotes\"</a>", (String)tag.html());
    }
}

