/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ChunkedDataProvider;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.io.Writer;
import java.nio.ByteBuffer;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChunkedResponse
extends Response {
    private ResponseSender sender;
    private int bytesSent = 0;
    private boolean dontChunk = false;
    private ChunkedDataProvider chunckedDataProvider;

    public ChunkedResponse(String format, ChunkedDataProvider chunckedDataProvider) {
        super(format);
        this.chunckedDataProvider = chunckedDataProvider;
        if (this.isTextFormat()) {
            this.dontChunk = true;
        }
    }

    public void sendTo(ResponseSender sender) {
        this.sender = sender;
        sender.send(this.makeHttpHeaders().getBytes());
        this.chunckedDataProvider.startSending();
    }

    protected void addStandardHeaders() {
        super.addStandardHeaders();
        if (!this.dontChunk) {
            this.addHeader("Transfer-Encoding", "chunked");
        }
    }

    public static String asHex(int value) {
        return Integer.toHexString(value);
    }

    public void add(String text) {
        if (text != null) {
            this.add(this.getEncodedBytes(text));
        }
    }

    public void add(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (this.dontChunk) {
            this.sender.send(bytes);
        } else {
            String sizeLine = ChunkedResponse.asHex((int)bytes.length) + "\r\n";
            ByteBuffer chunk = ByteBuffer.allocate(sizeLine.length() + bytes.length + 2);
            chunk.put(sizeLine.getBytes()).put(bytes).put("\r\n".getBytes());
            this.sender.send(chunk.array());
        }
        this.bytesSent += bytes.length;
    }

    public void addTrailingHeader(String key, String value) {
        if (!this.dontChunk) {
            String header = key + ": " + value + "\r\n";
            this.sender.send(header.getBytes());
        }
    }

    public void closeChunks() {
        if (!this.dontChunk) {
            this.sender.send("0\r\n".getBytes());
        }
    }

    public void closeTrailer() {
        if (!this.dontChunk) {
            this.sender.send("\r\n".getBytes());
        }
    }

    public void close() {
        this.sender.close();
    }

    public void closeAll() {
        this.closeChunks();
        this.closeTrailer();
        this.close();
    }

    public int getContentSize() {
        return this.bytesSent;
    }

    public void turnOffChunking() {
        this.dontChunk = true;
    }

    public boolean isChunkingTurnedOff() {
        return this.dontChunk;
    }

    public Writer getWriter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

