/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Request;
import fitnesse.http.RequestBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestBuilderTest
extends RegexTestCase {
    private RequestBuilder builder;

    public void setUp() {
        this.builder = new RequestBuilder("/");
    }

    public void testDeafultValues() throws Exception {
        this.builder = new RequestBuilder("/someResource");
        String text = this.builder.getText();
        RequestBuilderTest.assertHasRegexp((String)"GET /someResource HTTP/1.1\r\n", (String)text);
    }

    public void testHostHeader_RFC2616_section_14_23() throws Exception {
        this.builder = new RequestBuilder("/someResource");
        String text = this.builder.getText();
        RequestBuilderTest.assertSubString((String)"Host: \r\n", (String)text);
        this.builder.setHostAndPort("some.host.com", 123);
        text = this.builder.getText();
        RequestBuilderTest.assertSubString((String)"Host: some.host.com:123\r\n", (String)text);
    }

    public void testChangingMethod() throws Exception {
        this.builder.setMethod("POST");
        String text = this.builder.getText();
        RequestBuilderTest.assertHasRegexp((String)"POST / HTTP/1.1\r\n", (String)text);
    }

    public void testAddInput() throws Exception {
        this.builder.addInput("responder", (Object)"saveData");
        String content = "!fixture fit.ColumnFixture\n\n!path classes\n\n!2 ";
        this.builder.addInput("pageContent", (Object)content);
        String inputString = this.builder.inputString();
        RequestBuilderTest.assertSubString((String)"responder=saveData", (String)inputString);
        RequestBuilderTest.assertSubString((String)"pageContent=%21fixture+fit.ColumnFixture%0A%0A%21path+classes%0A%0A%212+", (String)inputString);
        RequestBuilderTest.assertSubString((String)"&", (String)inputString);
    }

    public void testGETMethodWithInputs() throws Exception {
        this.builder.addInput("key", (Object)"value");
        String text = this.builder.getText();
        RequestBuilderTest.assertSubString((String)"GET /?key=value HTTP/1.1\r\n", (String)text);
    }

    public void testPOSTMethodWithInputs() throws Exception {
        this.builder.setMethod("POST");
        this.builder.addInput("key", (Object)"value");
        String text = this.builder.getText();
        RequestBuilderTest.assertSubString((String)"POST / HTTP/1.1\r\n", (String)text);
        RequestBuilderTest.assertSubString((String)"key=value", (String)text);
    }

    public void testAddingCredentials() throws Exception {
        this.builder.addCredentials("Aladdin", "open sesame");
        RequestBuilderTest.assertSubString((String)"Authorization: Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (String)this.builder.getText());
    }

    public void testGetBoundary() throws Exception {
        String boundary = this.builder.getBoundary();
        RequestBuilderTest.assertEquals((String)boundary, (String)this.builder.getBoundary());
        RequestBuilderTest.assertFalse((boolean)boundary.equals(new RequestBuilder("blah").getBoundary()));
    }

    public void testMultipartOnePart() throws Exception {
        this.builder.addInputAsPart("myPart", (Object)"part data");
        String text = this.builder.getText();
        RequestBuilderTest.assertSubString((String)"POST", (String)text);
        RequestBuilderTest.assertSubString((String)"Content-Type: multipart/form-data; boundary=", (String)text);
        String boundary = this.builder.getBoundary();
        RequestBuilderTest.assertSubString((String)("--" + boundary), (String)text);
        RequestBuilderTest.assertSubString((String)"\r\n\r\npart data\r\n", (String)text);
        RequestBuilderTest.assertSubString((String)("--" + boundary + "--"), (String)text);
    }

    public void testMultipartWithInputStream() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("data from input stream".getBytes());
        this.builder.addInputAsPart("input", (InputStream)input, 89, "text/html");
        String text = this.builder.getText();
        RequestBuilderTest.assertSubString((String)"Content-Type: text/html", (String)text);
        RequestBuilderTest.assertSubString((String)"\r\n\r\ndata from input stream\r\n", (String)text);
    }

    public void testMultipartWithRequestParser() throws Exception {
        this.builder.addInputAsPart("part1", (Object)"data 1");
        this.builder.addInput("input1", (Object)"input1 value");
        this.builder.addInputAsPart("part2", (Object)"data 2");
        String text = this.builder.getText();
        Request request = new Request((InputStream)new ByteArrayInputStream(text.getBytes()));
        request.parse();
        RequestBuilderTest.assertEquals((Object)"data 1", (Object)request.getInput("part1"));
        RequestBuilderTest.assertEquals((Object)"data 2", (Object)request.getInput("part2"));
        RequestBuilderTest.assertEquals((Object)"input1 value", (Object)request.getInput("input1"));
    }
}

