/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.PrintTestListener;
import fitnesse.junit.TestHelper;
import fitnesse.responders.run.ResultsListener;
import fitnesse.testsystems.TestSummary;
import java.text.MessageFormat;
import org.junit.Assert;

public class JUnitHelper {
    private final TestHelper helper;
    private int port = 0;

    public void setPort(int port) {
        this.port = port;
    }

    public JUnitHelper(String fitNesseRootPath, String outputPath) {
        this(fitNesseRootPath, outputPath, (ResultsListener)new PrintTestListener());
    }

    public JUnitHelper(String fitNesseDir, String outputDir, ResultsListener resultsListener) {
        this.helper = new TestHelper(fitNesseDir, outputDir, resultsListener);
    }

    public void setDebugMode(boolean enabled) {
        this.helper.setDebugMode(enabled);
    }

    public void assertTestPasses(String testName) throws Exception {
        this.assertPasses(testName, "test", null);
    }

    public void assertSuitePasses(String suiteName) throws Exception {
        this.assertPasses(suiteName, "suite", null);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter) throws Exception {
        this.assertPasses(suiteName, "suite", suiteFilter);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter, String excludeSuiteFilter) throws Exception {
        this.assertPasses(suiteName, "suite", suiteFilter, excludeSuiteFilter);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter) throws Exception {
        this.assertPasses(pageName, pageType, suiteFilter, null);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter, String excludeSuiteFilter) throws Exception {
        TestSummary summary = this.helper.run(pageName, pageType, suiteFilter, excludeSuiteFilter, this.port);
        Assert.assertEquals((String)"wrong", (long)0L, (long)summary.wrong);
        Assert.assertEquals((String)"exceptions", (long)0L, (long)summary.exceptions);
        Assert.assertTrue((String)this.msgAtLeastOneTest(pageName, summary), (summary.right > 0 ? 1 : 0) != 0);
    }

    private String msgAtLeastOneTest(String pageName, TestSummary summary) {
        return MessageFormat.format("at least one test executed in {0}\n{1}", pageName, summary.toString());
    }
}

