/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.JUnitHelper;
import fitnesse.junit.JUnitXMLTestListener;
import fitnesse.responders.run.ResultsListener;
import fitnesse.testsystems.TestSummary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JUnitXmlTestListenerIntegrationTest {
    String htmlOutputDir = new File(System.getProperty("java.io.tmpdir"), "fitnesse").getAbsolutePath();
    String xmlOutputDir = new File(System.getProperty("java.io.tmpdir"), "fitnesse-xml").getAbsolutePath();
    String fitNesseRootDir = ".";
    JUnitXMLTestListener xmlTestListener = new JUnitXMLTestListener(this.xmlOutputDir);
    String expectedCorrectResultPattern = "<testsuite errors=\"0\" skipped=\"0\" tests=\"1\" time=\"[0-9\\.]*\" failures=\"0\" name=\"FitNesse.SuiteAcceptanceTests.SuiteSlimTests.MultiByteCharsInSlim\"><properties></properties><testcase classname=\"FitNesse.SuiteAcceptanceTests.SuiteSlimTests.MultiByteCharsInSlim\" time=\"[0-9\\.]*\" name=\"FitNesse.SuiteAcceptanceTests.SuiteSlimTests.MultiByteCharsInSlim\"></testcase></testsuite>";

    @Before
    public void setup() {
        System.setProperty("slim.port", "8200");
    }

    @After
    public void tearDown() {
        System.clearProperty("slim.port");
    }

    @Test
    public void checkJunitXmlTestListenerPrintsXmlFiles() throws Exception {
        JUnitHelper helper = new JUnitHelper(this.fitNesseRootDir, this.htmlOutputDir, (ResultsListener)this.xmlTestListener);
        helper.assertTestPasses("FitNesse.SuiteAcceptanceTests.SuiteSlimTests.MultiByteCharsInSlim");
        File expectedFile = new File(new File(this.xmlOutputDir), "TEST-FitNesse.SuiteAcceptanceTests.SuiteSlimTests.MultiByteCharsInSlim.xml");
        Assert.assertTrue((String)"file exists", (boolean)expectedFile.exists());
        String contents = this.readContents(expectedFile);
        Assert.assertTrue((String)("file contents are " + contents), (boolean)Pattern.matches(this.expectedCorrectResultPattern, contents));
    }

    @Test
    public void failuresAreRecordedCorrectly() throws Exception {
        this.xmlTestListener.recordTestResult("testName", new TestSummary(1, 2, 0, 0), 100L);
        Assert.assertEquals((Object)this.readContents(new File(this.xmlOutputDir, "TEST-testName.xml")), (Object)"<testsuite errors=\"0\" skipped=\"0\" tests=\"1\" time=\"0.1\" failures=\"1\" name=\"testName\"><properties></properties><testcase classname=\"testName\" time=\"0.1\" name=\"testName\"><failure type=\"java.lang.AssertionError\" message=\" exceptions: 0 wrong: 2\"></failure></testcase></testsuite>");
    }

    @Test
    public void exceptionsAreRecordedCorrectly() throws Exception {
        this.xmlTestListener.recordTestResult("testName", new TestSummary(1, 2, 0, 1), 100L);
        Assert.assertEquals((Object)this.readContents(new File(this.xmlOutputDir, "TEST-testName.xml")), (Object)"<testsuite errors=\"1\" skipped=\"0\" tests=\"1\" time=\"0.1\" failures=\"0\" name=\"testName\"><properties></properties><testcase classname=\"testName\" time=\"0.1\" name=\"testName\"><failure type=\"java.lang.AssertionError\" message=\" exceptions: 1 wrong: 2\"></failure></testcase></testsuite>");
    }

    private String readContents(File expectedFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(expectedFile));
        StringBuffer buffer = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            line = reader.readLine();
        }
        reader.close();
        return buffer.toString();
    }
}

