/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.editing.EditResponder;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestPageWithSuiteSetUpAndTearDown;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageActions;
import fitnesse.wiki.WikiPagePath;

public class WikiPageResponder
implements SecureResponder {
    private WikiPage page;
    private PageCrawler crawler;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.loadPage(request.getResource(), context);
        if (this.page == null) {
            return this.notFoundResponse(context, request);
        }
        return this.makePageResponse(context);
    }

    protected void loadPage(String pageName, FitNesseContext context) {
        WikiPagePath path = PathParser.parse((String)pageName);
        this.crawler = context.root.getPageCrawler();
        this.page = this.crawler.getPage(context.root, path);
    }

    private Response notFoundResponse(FitNesseContext context, Request request) {
        if (this.dontCreateNonExistentPage(request)) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        return new EditResponder().makeResponseForNonExistentPage(context, request);
    }

    private boolean dontCreateNonExistentPage(Request request) {
        String dontCreate = (String)request.getInput("dontCreatePage");
        return dontCreate != null && (dontCreate.length() == 0 || Boolean.parseBoolean(dontCreate));
    }

    private SimpleResponse makePageResponse(FitNesseContext context) {
        PathParser.render((WikiPagePath)this.crawler.getFullPath(this.page));
        String html = this.makeHtml(context);
        SimpleResponse response = new SimpleResponse();
        response.setMaxAge(0);
        response.setContent(html);
        return response;
    }

    public String makeHtml(FitNesseContext context) {
        PageData pageData = this.page.getData();
        WikiPage page = pageData.getWikiPage();
        HtmlPage html = context.pageFactory.newPage();
        WikiPagePath fullPath = page.getPageCrawler().getFullPath(page);
        String fullPathName = PathParser.render((WikiPagePath)fullPath);
        PageTitle pt = new PageTitle(fullPath);
        String tags = "";
        if (pageData != null) {
            tags = pageData.getAttribute("Suites");
        }
        pt.setPageTags(tags);
        html.setTitle(fullPathName);
        html.setPageTitle(pt.notLinked());
        html.setNavTemplate("wikiNav.vm");
        html.put("actions", (Object)new WikiPageActions(page));
        html.put("helpText", (Object)pageData.getProperties().get("Help"));
        if (TestPage.isTestPage((PageData)pageData)) {
            TestPageWithSuiteSetUpAndTearDown testPage = new TestPageWithSuiteSetUpAndTearDown(page);
            html.put("content", (Object)new WikiPageRenderer(this, testPage.getDecoratedData()));
        } else {
            html.put("content", (Object)new WikiPageRenderer(this, page.getData()));
        }
        html.setMainTemplate("wikiPage");
        html.setFooterTemplate("wikiFooter");
        html.put("footerContent", (Object)new WikiPageFooterRenderer(this));
        this.handleSpecialProperties(html, page);
        return html.html();
    }

    private void handleSpecialProperties(HtmlPage html, WikiPage page) {
        WikiImportProperty.handleImportProperties((HtmlPage)html, (WikiPage)page);
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    static /* synthetic */ WikiPage access$000(WikiPageResponder x0) {
        return x0.page;
    }
}

