/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.RecentChanges;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Arrays;
import java.util.LinkedList;

public class SavePropertiesResponder
implements SecureResponder {
    public Response makeResponse(FitNesseContext context, Request request) {
        SimpleResponse response = new SimpleResponse();
        String resource = request.getResource();
        WikiPagePath path = PathParser.parse((String)resource);
        WikiPage page = context.root.getPageCrawler().getPage(context.root, path);
        if (page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        PageData data = page.getData();
        this.saveAttributes(request, data);
        VersionInfo commitRecord = page.commit(data);
        response.addHeader("Previous-Version", commitRecord.getName());
        RecentChanges.updateRecentChanges((PageData)data);
        response.redirect(resource);
        return response;
    }

    private void saveAttributes(Request request, PageData data) {
        this.setPageTypeAttribute(request, data);
        LinkedList<String> attrs = new LinkedList<String>();
        attrs.addAll(Arrays.asList(PageData.NON_SECURITY_ATTRIBUTES));
        attrs.addAll(Arrays.asList(PageData.SECURITY_ATTRIBUTES));
        attrs.add("Prune");
        for (String attribute : attrs) {
            if (this.isChecked(request, attribute)) {
                data.setAttribute(attribute);
                continue;
            }
            data.removeAttribute(attribute);
        }
        String suites = (String)request.getInput("Suites");
        data.setAttribute("Suites", suites);
        String helpText = (String)request.getInput("HelpText");
        data.setAttribute("Help", helpText);
    }

    private void setPageTypeAttribute(Request request, PageData data) {
        String pageType = this.getPageType(request);
        if (pageType == null) {
            return;
        }
        LinkedList<String> types = new LinkedList<String>();
        types.addAll(Arrays.asList(PageData.PAGE_TYPE_ATTRIBUTES));
        data.setAttribute(pageType);
        for (String type : types) {
            if (pageType.equals(type)) continue;
            data.removeAttribute(type);
        }
    }

    private String getPageType(Request request) {
        return (String)request.getInput("PageType");
    }

    private boolean isChecked(Request request, String name) {
        return request.getInput(name) != null;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

