/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.components.RecentChanges;
import fitnesse.components.SaveRecorder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.responders.editing.MergeResponder;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class SaveResponder
implements SecureResponder {
    public static ContentFilter contentFilter;
    private String user;
    private long ticketId;
    private String savedContent;
    private String helpText;
    private String suites;
    private PageData data;
    private long editTimeStamp;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.editTimeStamp = this.getEditTime(request);
        this.ticketId = this.getTicketId(request);
        String resource = request.getResource();
        WikiPage page = this.getPage(resource, context);
        this.data = page.getData();
        this.user = request.getAuthorizationUsername();
        if (this.editsNeedMerge()) {
            return new MergeResponder(request).makeResponse(context, request);
        }
        this.savedContent = (String)request.getInput("pageContent");
        this.helpText = (String)request.getInput("helpText");
        this.suites = (String)request.getInput("suites");
        if (contentFilter != null && !contentFilter.isContentAcceptable(this.savedContent, resource)) {
            return this.makeBannedContentResponse(context, resource);
        }
        return this.saveEdits(context, request, page);
    }

    private Response makeBannedContentResponse(FitNesseContext context, String resource) {
        SimpleResponse response = new SimpleResponse();
        HtmlPage html = context.pageFactory.newPage();
        html.setTitle("Edit " + resource);
        html.setPageTitle(new PageTitle("Banned Content", PathParser.parse((String)resource)));
        html.setMainTemplate("bannedPage.vm");
        response.setContent(html.html());
        return response;
    }

    private Response saveEdits(FitNesseContext context, Request request, WikiPage page) {
        SimpleResponse response = new SimpleResponse();
        this.setData();
        VersionInfo commitRecord = page.commit(this.data);
        response.addHeader("Previous-Version", commitRecord.getName());
        RecentChanges.updateRecentChanges((PageData)this.data);
        if (request.hasInput("redirect")) {
            response.redirect(request.getInput("redirect").toString());
        } else {
            response.redirect(request.getResource());
        }
        return response;
    }

    private boolean editsNeedMerge() {
        return SaveRecorder.changesShouldBeMerged((long)this.editTimeStamp, (long)this.ticketId, (PageData)this.data);
    }

    private long getTicketId(Request request) {
        if (!request.hasInput("ticketId")) {
            return 0L;
        }
        String ticketIdString = (String)request.getInput("ticketId");
        return Long.parseLong(ticketIdString);
    }

    private long getEditTime(Request request) {
        if (!request.hasInput("editTime")) {
            return 0L;
        }
        String editTimeStampString = (String)request.getInput("editTime");
        long editTimeStamp = Long.parseLong(editTimeStampString);
        return editTimeStamp;
    }

    private WikiPage getPage(String resource, FitNesseContext context) {
        WikiPagePath path = PathParser.parse((String)resource);
        PageCrawler pageCrawler = context.root.getPageCrawler();
        WikiPage page = pageCrawler.getPage(context.root, path);
        if (page == null) {
            page = pageCrawler.addPage(context.root, PathParser.parse((String)resource));
        }
        return page;
    }

    private void setData() {
        this.data.setContent(this.savedContent);
        this.setAttribute("Help", this.helpText);
        this.setAttribute("Suites", this.suites);
        SaveRecorder.pageSaved((PageData)this.data, (long)this.ticketId);
        this.setAttribute("LastModifyingUser", this.user);
    }

    private void setAttribute(String property, String content) {
        if (content == null || "".equals(content)) {
            this.data.removeAttribute(property);
        } else {
            this.data.setAttribute(property, content);
        }
    }

    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }
}

