/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.components.ClassPathBuilder;
import fitnesse.responders.PageFactory;
import fitnesse.responders.run.PagesByTestSystem;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.Stoppable;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.testsystems.PageListSetUpTearDownSurrounder;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemGroup;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import util.TimeMeasurement;

public class MultipleTestsRunner
implements TestSystemListener,
Stoppable {
    private final ResultsListener resultsListener;
    private final FitNesseContext fitNesseContext;
    private final WikiPage page;
    private final List<WikiPage> testPagesToRun;
    private boolean isFastTest = false;
    private boolean isRemoteDebug = false;
    private LinkedList<TestPage> processingQueue = new LinkedList();
    private TestPage currentTest = null;
    private TestSystemGroup testSystemGroup = null;
    private volatile boolean isStopped = false;
    private String stopId = null;
    private PageListSetUpTearDownSurrounder surrounder;
    TimeMeasurement currentTestTime;
    TimeMeasurement totalTestTime;

    public MultipleTestsRunner(List<WikiPage> testPagesToRun, FitNesseContext fitNesseContext, WikiPage page, ResultsListener resultsListener) {
        this.testPagesToRun = testPagesToRun;
        this.resultsListener = resultsListener;
        this.page = page;
        this.fitNesseContext = fitNesseContext;
        this.surrounder = new PageListSetUpTearDownSurrounder(fitNesseContext.root);
    }

    public void setDebug(boolean isDebug) {
        this.isRemoteDebug = isDebug;
    }

    public void setFastTest(boolean isFastTest) {
        this.isFastTest = isFastTest;
    }

    public void executeTestPages() {
        try {
            this.internalExecuteTestPages();
            this.allTestingComplete();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            this.exceptionOccurred((Throwable)exception);
        }
    }

    void allTestingComplete() throws IOException {
        TimeMeasurement completionTimeMeasurement = new TimeMeasurement().start();
        this.resultsListener.allTestingComplete(this.totalTestTime.stop());
        completionTimeMeasurement.stop();
    }

    private void internalExecuteTestPages() throws IOException, InterruptedException {
        this.testSystemGroup = new TestSystemGroup(this.fitNesseContext, this.page, (TestSystemListener)this);
        this.stopId = this.fitNesseContext.runningTestingTracker.addStartedProcess((Stoppable)this);
        this.testSystemGroup.setFastTest(this.isFastTest);
        this.testSystemGroup.setManualStart(this.useManualStartForTestSystem());
        this.resultsListener.setExecutionLogAndTrackingId(this.stopId, this.testSystemGroup.getExecutionLog());
        PagesByTestSystem pagesByTestSystem = this.makeMapOfPagesByTestSystem();
        this.announceTotalTestsToRun(pagesByTestSystem);
        for (Map.Entry PagesByTestSystem2 : pagesByTestSystem.entrySet()) {
            this.startTestSystemAndExecutePages((TestSystem.Descriptor)PagesByTestSystem2.getKey(), (List)PagesByTestSystem2.getValue());
        }
        this.fitNesseContext.runningTestingTracker.removeEndedProcess(this.stopId);
    }

    private boolean useManualStartForTestSystem() {
        if (this.isRemoteDebug) {
            String useManualStart = this.page.readOnlyData().getVariable("MANUALLY_START_TEST_RUNNER_ON_DEBUG");
            return useManualStart != null && useManualStart.toLowerCase().equals("true");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTestSystemAndExecutePages(TestSystem.Descriptor descriptor, List<TestPage> testSystemPages) throws IOException, InterruptedException {
        TestSystem testSystem = null;
        try {
            if (!this.isStopped) {
                testSystem = this.testSystemGroup.startTestSystem(descriptor, new ClassPathBuilder().buildClassPath(this.testPagesToRun));
                this.resultsListener.testSystemStarted(testSystem, descriptor.getTestSystem(), descriptor.getTestRunner());
            }
            if (testSystem != null && testSystem.isSuccessfullyStarted()) {
                this.executeTestSystemPages(testSystemPages, testSystem);
                this.waitForTestSystemToSendResults();
            }
        }
        finally {
            if (!this.isStopped && testSystem != null) {
                testSystem.bye();
            }
        }
    }

    private void executeTestSystemPages(List<TestPage> pagesInTestSystem, TestSystem testSystem) throws IOException, InterruptedException {
        for (TestPage testPage : pagesInTestSystem) {
            this.addToProcessingQueue(testPage);
            testSystem.runTests(testPage);
        }
    }

    void addToProcessingQueue(TestPage testPage) {
        this.processingQueue.addLast(testPage);
    }

    private void waitForTestSystemToSendResults() throws InterruptedException {
        while (this.processingQueue.size() > 0 && this.isNotStopped()) {
            Thread.sleep(50L);
        }
    }

    PagesByTestSystem makeMapOfPagesByTestSystem() {
        return this.addSuiteSetUpAndTearDownToAllTestSystems(this.mapWithAllPagesButSuiteSetUpAndTearDown());
    }

    private PagesByTestSystem mapWithAllPagesButSuiteSetUpAndTearDown() {
        PagesByTestSystem pagesByTestSystem = new PagesByTestSystem();
        for (WikiPage testPage : this.testPagesToRun) {
            if (SuiteContentsFinder.isSuiteSetupOrTearDown((WikiPage)testPage)) continue;
            this.addPageToListWithinMap(pagesByTestSystem, testPage);
        }
        return pagesByTestSystem;
    }

    private void addPageToListWithinMap(PagesByTestSystem pagesByTestSystem, WikiPage wikiPage) {
        TestPage testPage = new TestPage(wikiPage);
        TestSystem.Descriptor descriptor = TestSystem.getDescriptor((WikiPage)wikiPage, (PageFactory)this.fitNesseContext.pageFactory, (boolean)this.isRemoteDebug);
        this.getOrMakeListWithinMap(pagesByTestSystem, descriptor).add(testPage);
    }

    private LinkedList<TestPage> getOrMakeListWithinMap(PagesByTestSystem pagesByTestSystem, TestSystem.Descriptor descriptor) {
        LinkedList pagesForTestSystem;
        if (!pagesByTestSystem.containsKey((Object)descriptor)) {
            pagesForTestSystem = new LinkedList();
            pagesByTestSystem.put((Object)descriptor, (Object)pagesForTestSystem);
        } else {
            pagesForTestSystem = (LinkedList)pagesByTestSystem.get((Object)descriptor);
        }
        return pagesForTestSystem;
    }

    private PagesByTestSystem addSuiteSetUpAndTearDownToAllTestSystems(PagesByTestSystem pagesByTestSystem) {
        if (this.testPagesToRun.size() == 0) {
            return pagesByTestSystem;
        }
        for (LinkedList pagesForTestSystem : pagesByTestSystem.values()) {
            this.surrounder.surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns((List)pagesForTestSystem);
        }
        return pagesByTestSystem;
    }

    void announceTotalTestsToRun(PagesByTestSystem pagesByTestSystem) {
        int tests = 0;
        for (LinkedList listOfPagesToRun : pagesByTestSystem.values()) {
            tests += listOfPagesToRun.size();
        }
        this.resultsListener.announceNumberTestsToRun(tests);
        this.totalTestTime = new TimeMeasurement().start();
    }

    public void testOutputChunk(String output) throws IOException {
        boolean isNewTest;
        TestPage firstInQueue = this.processingQueue.isEmpty() ? null : (TestPage)this.processingQueue.getFirst();
        boolean bl = isNewTest = firstInQueue != null && firstInQueue != this.currentTest;
        if (isNewTest) {
            this.startingNewTest(firstInQueue);
        }
        this.resultsListener.testOutputChunk(output);
    }

    void startingNewTest(TestPage test) throws IOException {
        this.currentTest = test;
        this.currentTestTime = new TimeMeasurement().start();
        this.resultsListener.newTestStarted(this.currentTest, this.currentTestTime);
    }

    public void testComplete(TestSummary testSummary) throws IOException {
        TestPage testPage = (TestPage)this.processingQueue.removeFirst();
        this.resultsListener.testComplete(testPage, testSummary, this.currentTestTime.stop());
    }

    public void exceptionOccurred(Throwable e) {
        block2: {
            try {
                this.resultsListener.errorOccured();
                this.stop();
            }
            catch (Exception e1) {
                if (!this.isNotStopped()) break block2;
                e1.printStackTrace();
            }
        }
    }

    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        this.resultsListener.testAssertionVerified(assertion, testResult);
    }

    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        this.resultsListener.testExceptionOccurred(assertion, exceptionResult);
    }

    private boolean isNotStopped() {
        return !this.isStopped;
    }

    public void stop() throws IOException {
        boolean wasNotStopped = this.isNotStopped();
        this.isStopped = true;
        if (this.stopId != null) {
            this.fitNesseContext.runningTestingTracker.removeEndedProcess(this.stopId);
        }
        if (wasNotStopped) {
            this.testSystemGroup.kill();
        }
    }
}

